
/**
 * Project Name:tuia-youtui-web<br>
 * File Name:GetSkinConfigRsp.java<br>
 * Package Name:com.duiba.tuia.youtui.web.model.rsp<br>
 * Date:2017年2月10日上午11:06:24<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */

package com.duiba.tuia.youtui.web.model.rsp;

import cn.com.duiba.tuia.activity.center.api.constant.PluginType;
import cn.com.duiba.tuia.activity.center.api.dto.ActivityPluginDto;
import com.duiba.tuia.youtui.web.biz.interfaces.ImageBusiness;
import com.duiba.tuia.youtui.web.tool.DomainUtil;

import java.io.Serializable;


/**
 * ClassName: GetSkinConfigRsp <br/>
 * date: 2017年2月10日 上午11:06:24 <br/>
 *
 * @author youhaijun
 * @version
 * @since JDK 1.6
 */
public class PluginToolsRsp implements Serializable, ImageBusiness {


    /**
     * serialVersionUID.
     * @since JDK 1.7
     */
    private static final long serialVersionUID = 1196222234407263675L;

    /** 皮肤 */
    private String skinConfig;

    // 是否新弹层
    private Boolean isNew;

    /** The id. */
    private Long id;

    /** 活动类型，插件工具为2000. */
    private Integer type;

    /** The slot id. */
    private Long slotId;

    /** 皮肤ID. */
    private Long skinId;

    /** 皮肤名称. */
    private String skinName;

    /** 插件名称. */
    private String title;

    /** 触发结果 1：直接发奖 2: 跳转页面，默认为1. */
    private Integer triggerType;

    /** 跳转页面url，当triggerType=2时候生效. */
    private String triggerUrl;

    /**  埋点链接  */
    private String embedData;

    /**关闭按钮埋点*/
    private String closeClickEmbedData;

    /**更多按钮点击**/
    private String moreClickEmbedData;

    /**更多按钮曝光**/
    private String moreEmbedData;

    /**优先级(1：插件高于浮标，2：插件与浮标同时出现)*/
    private Integer priority;

    public PluginToolsRsp() {
    }

    public PluginToolsRsp(ActivityPluginDto dto, PluginType pluginType) {

    }

    public PluginToolsRsp(ActivityPluginDto dto, int pluginType) {

    }

    public Integer getPriority() {
        return priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public String getEmbedData() {
        return embedData;
    }


    public void setEmbedData(String embedData) {
        this.embedData = embedData;
    }


    public Integer getType() {
        return type;
    }


    public void setType(Integer type) {
        this.type = type;
    }


    public Long getSlotId() {
        return slotId;
    }


    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }


    public String getSkinName() {
        return skinName;
    }


    public void setSkinName(String skinName) {
        this.skinName = skinName;
    }


    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }


    public Long getSkinId() {
        return skinId;
    }


    public void setSkinId(Long skinId) {
        this.skinId = skinId;
    }


    public String getTitle() {
        return title;
    }


    public void setTitle(String title) {
        this.title = title;
    }


    public Integer getTriggerType() {
        return triggerType;
    }


    public void setTriggerType(Integer triggerType) {
        this.triggerType = triggerType;
    }


    public String getTriggerUrl() {
        return triggerUrl;
    }


    public void setTriggerUrl(String triggerUrl) {
        this.triggerUrl = triggerUrl;
    }


    public Boolean getIsNew() {
        return isNew;
    }


    public void setIsNew(Boolean isNew) {
        this.isNew = isNew;
    }


    public String getSkinConfig() {
        return skinConfig;
    }


    public void setSkinConfig(String skinConfig) {
        this.skinConfig = skinConfig;
    }

    @Override
    public void replaceDomain(String domain) {
        skinConfig = DomainUtil.replaceDomain(skinConfig, domain);
    }

    public String getCloseClickEmbedData() {
        return closeClickEmbedData;
    }

    public void setCloseClickEmbedData(String closeClickEmbedData) {
        this.closeClickEmbedData = closeClickEmbedData;
    }

    public String getMoreClickEmbedData() {
        return moreClickEmbedData;
    }

    public void setMoreClickEmbedData(String moreClickEmbedData) {
        this.moreClickEmbedData = moreClickEmbedData;
    }

    public String getMoreEmbedData() {
        return moreEmbedData;
    }

    public void setMoreEmbedData(String moreEmbedData) {
        this.moreEmbedData = moreEmbedData;
    }
}

