
/**
 * Project Name:tuia-youtui-web<br>
 * File Name:GetSkinConfigRsp.java<br>
 * Package Name:com.duiba.tuia.youtui.web.model.rsp<br>
 * Date:2017年2月10日上午11:06:24<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 *
 */

package com.duiba.tuia.youtui.web.model.rsp;

import com.duiba.tuia.youtui.web.biz.interfaces.ImageBusiness;
import com.duiba.tuia.youtui.web.tool.DomainUtil;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;


/**
 * ClassName: GetSkinConfigRsp <br/>
 * date: 2017年2月10日 上午11:06:24 <br/>
 *
 * @author youhaijun
 * @version 
 * @since JDK 1.6
 */
public class GetSkinConfigRsp implements Serializable,ImageBusiness{

    /**
     * @since JDK 1.6
     */
    private static final long serialVersionUID = -444784603178640198L;
    
    private String skinConfig;
    
    // 是否新弹层
    private Boolean isNew ;

    @ApiModelProperty(value = "客服信息", required = false)
    private String contaction;

    public String getContaction() {
        return contaction;
    }

    public void setContaction(String contaction) {
        this.contaction = contaction;
    }

    public Boolean getIsNew() {
        return isNew;
    }


    
    public void setIsNew(Boolean isNew) {
        this.isNew = isNew;
    }


    public String getSkinConfig() {
        return skinConfig;
    }

    
    public void setSkinConfig(String skinConfig) {
        this.skinConfig = skinConfig;
    }

    @Override
    public void replaceDomain(String domain) {
        skinConfig = DomainUtil.replaceDomain(skinConfig, domain);
    }
}

