
/**
 * Project Name:tuia-youtui-web<br>
 * File Name:GetActivitysRsp.java<br>
 * Package Name:com.duiba.tuia.youtui.web.model.rsp<br>
 * Date:2017年3月20日下午7:05:52<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 *
 */

package com.duiba.tuia.youtui.web.model.rsp;

import java.util.List;
import java.util.Map;

import com.duiba.tuia.youtui.web.biz.interfaces.ImageBusiness;
import com.duiba.tuia.youtui.web.model.ActivityForActCenterVO;
import com.duiba.tuia.youtui.web.tool.DomainUtil;

/**
 * ClassName: GetActivitysRsp <br/>
 * date: 2017年3月20日 下午7:05:52 <br/>
 *
 * @author youhaijun
 * @version 
 * @since JDK 1.6
 */
public class GetActivitysRsp implements ImageBusiness{

    private List<ActivityForActCenterVO> list;


    
    public List<ActivityForActCenterVO> getList() {
        return list;
    }

    
    public void setList(List<ActivityForActCenterVO> list) {
        this.list = list;
    }


    @Override
    public void replaceDomain(String domain) {
        if (null != list && list.size() > 0) {
            for (ActivityForActCenterVO vo : list) {
                vo.setBannerUrl(DomainUtil.replaceDomain(vo.getBannerUrl(), domain));
                vo.setRecommendUrl(DomainUtil.replaceDomain(vo.getRecommendUrl(), domain));
                vo.setListUrl(DomainUtil.replaceDomain(vo.getListUrl(), domain));
            }
        }
    }
}

