package com.duiba.tuia.youtui.web.model.rsp;

import cn.com.duiba.tuia.activity.center.api.constant.LoginType;
import com.duiba.tuia.youtui.web.model.direct.Block;
import com.duiba.tuia.youtui.web.model.direct.Region;
import com.duiba.tuia.youtui.web.model.req.DirectPageReq;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by wubo on 2017/8/31.
 */
public class DirectBlockRsp {

    /**
     * 直投页id
     */
    private Long         pageId;

    /**
     * 区域内容
     */
    private Map<String,Region> region;

    private int regionNum = 0;

    public DirectBlockRsp() {
    }

    public DirectBlockRsp(Long pageId) {
        this.pageId = pageId;
    }

    public Long getPageId() {
        return pageId;
    }

    public void setPageId(Long pageId) {
        this.pageId = pageId;
    }

    public Map<String, Region> getRegion() {
        return region;
    }

    public void setRegion(Map<String, Region> region) {
        this.region = region;
    }

    public void addBlock(Block block, String regionName, Integer regionType, DirectPageReq req, String domain, Long directPage, boolean custom) {
        if (block == null) {
            return;
        }
        if (region == null) {
            region = new HashMap<>();
        }
        final boolean[] firstBlock = {false};
        Region r = region.computeIfAbsent(regionName, k -> {
            regionNum++;
            firstBlock[0] = true;
            return new Region(regionName, regionType);
        });
        // 定制需求
        if (Long.valueOf(961L).equals(req.getPageId()) && "icon区".equals(r.getRegionName()) && firstBlock[0] && custom) {
            return;
        }
        r.addBlock(block);
        // 生成埋点信息
        block.buildEmbed(req.getDsm(), regionNum, r.getBlockNum(), req.getConsumerId(), req.getAppId(), req.getHost(), directPage);

        // 生成区块url
        block.buildUrl(req);

        //静态域名替换
        block.replaceDomain(domain);
        if (LoginType.PREVIEW.equalsCode(req.getLogin())) {
            block.setUrl("");//预览 不允许点击
        }

    }
}
