package com.duiba.tuia.youtui.web.model.req;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.commons.codec.digest.DigestUtils;

/**
 * Created by Administrator on 2017/12/14.
 */
public class YiDunVerifyReq implements Serializable {
    public static final String SECRET_KEY = "6b11e450571f0b0ad5ab01be114d393f";
    public static final String URL = "http://c.dun.163yun.com/api/v2/verify";
    private String captchaId = "6dec28573ed643268f0cffb1ef8c4b04";

    private String validate;

    private String user;
    private String secretId = "008c40520ee0ed4490f169f31eaf9c6d";
    private String version = "v2";
    private String timestamp = String.valueOf(System.currentTimeMillis());
    private String nonce = String.valueOf(new Random().nextInt(100));
    private String signature;

    public String getCaptchaId() {
        return captchaId;
    }

    public void setCaptchaId(String captchaId) {
        this.captchaId = captchaId;
    }

    public String getValidate() {
        return validate;
    }

    public void setValidate(String validate) {
        this.validate = validate;
    }

    public String getUser() {
        return user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getSecretId() {
        return secretId;
    }

    public void setSecretId(String secretId) {
        this.secretId = secretId;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public String getNonce() {
        return nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public String getSignature() {
        return signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public Map<String, String> setMap() {
        Map<String, String> map = new HashMap<>();
        map.put("captchaId", this.captchaId);
        map.put("nonce", this.nonce);
        map.put("secretId", this.secretId);
        map.put("timestamp", this.timestamp);
        map.put("user", this.user);
        map.put("validate", this.validate);
        map.put("version", this.version);
        return map;
    }

    /**
     * 生成签名信息
     *
     * @param secretKey 产品私钥
     * @param params 接口请求参数名和参数值map，不包括signature参数名
     * @return
     */
    public static String genSignature(String secretKey, Map<String, String> params) throws UnsupportedEncodingException {
        // 1. 参数名按照ASCII码表升序排序
        String[] keys = params.keySet().toArray(new String[0]);
        Arrays.sort(keys);

        // 2. 按照排序拼接参数名与参数值
        StringBuilder sb = new StringBuilder();
        for (String key : keys) {
            sb.append(key).append(params.get(key));
        }
        // 3. 将secretKey拼接到最后
        sb.append(secretKey);

        // 4. MD5是128位长度的摘要算法，转换为十六进制之后长度为32字符
        return DigestUtils.md5Hex(sb.toString().getBytes("UTF-8"));
    }
}
