
/**
 * Project Name:tuia-youtui-web<br>
 * File Name:GetActivitysReq.java<br>
 * Package Name:com.duiba.tuia.youtui.web.model.req<br>
 * Date:2017年3月20日下午6:44:23<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 *
 */

package com.duiba.tuia.youtui.web.model.req;

import io.swagger.annotations.ApiModel;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;


/**
 * 今日头条用户不喜欢上报请求参数
 * ClassName: TclickReq <br/>
 * date: 2017年8月20日 下午6:44:23 <br/>
 *
 * @author cdm
 * @version 
 * @since JDK 1.6
 */
@ApiModel
public class TdislikeReq {


    private String action;// 动作名称 填'dislike'

    private Long type; //  新闻分类  告:3,新闻:1 , 必填

    private Long id; //  新闻 id group_id

    private Long timestamp; //  上报时间  上报时的秒级时间戳

    private Long ad_id; //  ad_id 值, 当为 告时必填


    private Long item_id; //  新闻信息中的 item_id

    private String filter_words;// dislike 的原因


    private String ad_extra;// {'clicked': True}, // clicked 表示点击 dislike 动作时,条 目 是否点击过


    private Long  consumerId;//用户ID

    private Long appId;//appId

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }


    public String getAction() {
        return action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public Long getType() {
        return type;
    }

    public void setType(Long type) {
        this.type = type;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public Long getAd_id() {
        return ad_id;
    }

    public void setAd_id(Long ad_id) {
        this.ad_id = ad_id;
    }

    public Long getItem_id() {
        return item_id;
    }

    public void setItem_id(Long item_id) {
        this.item_id = item_id;
    }

    public String getFilter_words() {
        return filter_words;
    }

    public void setFilter_words(String filter_words) {
        this.filter_words = filter_words;
    }

    public String getAd_extra() {
        return StringUtils.isBlank(ad_extra)? ad_extra : StringEscapeUtils.unescapeHtml3(ad_extra);
    }

    public void setAd_extra(String ad_extra) {
        this.ad_extra = ad_extra;
    }
}

