
/**
 * Project Name:tuia-youtui-web<br>
 * File Name:GetActivitysReq.java<br>
 * Package Name:com.duiba.tuia.youtui.web.model.req<br>
 * Date:2017年3月20日下午6:44:23<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 *
 */

package com.duiba.tuia.youtui.web.model.req;

import io.swagger.annotations.ApiModel;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;


/**
 * ClassName: GetActivitysReq <br/>
 * date: 2017年3月20日 下午6:44:23 <br/>
 *
 * @author youhaijun
 * @version 
 * @since JDK 1.6
 */
@ApiModel
public class RechargeQBReq {


    @NotNull(message = "订单号不可为空")
    @Length(min=13, max=64)
    private String orderId;//订单号

    @NotNull(message = "qq号不可为空")
    @Pattern(regexp = "^[1-9][0-9]{4,} $", message = "您输入的qq格式错误,请重新输入.")
    private String account;//用户账户

    @NotNull(message = "金额不可为空")
    @Length(min=1, max=5)
    private String amount;//金额

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getAmount() {
        return amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }
}

