package com.duiba.tuia.youtui.web.model.req;

import java.io.Serializable;

import io.swagger.annotations.ApiModel;

import javax.validation.constraints.NotNull;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;

/**
 * ClassName: PluginToolsReq <br/>
 * Function: 插件工具请求. <br/>
 * date: 2017年5月11日 下午4:42:56 <br/>
 *
 * @author cdm
 * @version
 * @since JDK 1.7
 */
@ApiModel
public class PluginToolsReq  implements Serializable {

    /**
     * @since JDK 1.7
     */
    private static final long serialVersionUID = 5861243148565119655L;

    /** 主页面ID  ，  主页面ID 以后可能扩展为活动ID. */
    @NotNull(message = "活动ID不可为空")
    private Long mainPageId;

    /** The 主页面类型（0:预览 ；1:主会场；2:活动中心；3:直投页；4:活动）. */
    private Integer mainPageType;

    /** 用户 访问主页面的次数，24小时分开.例：1:3;2:4;3:0......22:2;23:0 */
    private String timeNum;

    /**  插件工具ID，预览的时候 */
    private Long  pluginToolId ;

    /**  插件工具ID，预览状态 */
    private String login;

    /** 区块名称*/
    private String blockName;

    /** 嵌入式插件 次数*/
    private String count;

    /** 响应式插件 参与次数 */
    private String joinTimes;

    /** 用户ip */
    private String ip;

    private String host;

    private String yunDomain;

    private String referer;

    private String havePluginIds;

    private String tenter;

    /**
     * 广告位是否有定制插件
     */
    private boolean customPlugin = false;

    public String getJoinTimes() {
        return StringUtils.isBlank(joinTimes)? joinTimes : StringEscapeUtils.unescapeHtml3(joinTimes);
    }

    public void setJoinTimes(String joinTimes) {
        this.joinTimes = joinTimes;
    }

    public String getLogin() {
        return login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public Long getPluginToolId() {
        return pluginToolId;
    }

    public void setPluginToolId(Long pluginToolId) {
        this.pluginToolId = pluginToolId;
    }

    public Long getMainPageId() {
        return mainPageId;
    }

    public void setMainPageId(Long mainPageId) {
        this.mainPageId = mainPageId;
    }

    public Integer getMainPageType() {
        return mainPageType;
    }

    public void setMainPageType(Integer mainPageType) {
        this.mainPageType = mainPageType;
    }

    public String getTimeNum() {
        return StringUtils.isBlank(timeNum)? timeNum : StringEscapeUtils.unescapeHtml3(timeNum);
    }

    public void setTimeNum(String timeNum) {
        this.timeNum = timeNum;
    }

    public String getBlockName() {
        return blockName;
    }

    public void setBlockName(String blockName) {
        this.blockName = blockName;
    }

    public String getCount() {
        return StringUtils.isBlank(count)? count : StringEscapeUtils.unescapeHtml3(count);
    }

    public void setCount(String count) {
        this.count = count;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getYunDomain() {
        return yunDomain;
    }

    public void setYunDomain(String yunDomain) {
        this.yunDomain = yunDomain;
    }

    public String getReferer() {
        return referer;
    }

    public void setReferer(String referer) {
        this.referer = referer;
    }

    public String getHavePluginIds() {
        return havePluginIds;
    }

    public void setHavePluginIds(String havePluginIds) {
        this.havePluginIds = havePluginIds;
    }

    public String getTenter() {
        return tenter;
    }

    public void setTenter(String tenter) {
        this.tenter = tenter;
    }

    public boolean isCustomPlugin() {
        return customPlugin;
    }

    public void setCustomPlugin(boolean customPlugin) {
        this.customPlugin = customPlugin;
    }
}
