
/**
 * Project Name:tuia-youtui-web<br>
 * File Name:GetActivitysReq.java<br>
 * Package Name:com.duiba.tuia.youtui.web.model.req<br>
 * Date:2017年3月20日下午6:44:23<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 *
 */

package com.duiba.tuia.youtui.web.model.req;

import io.swagger.annotations.ApiModel;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.hibernate.validator.constraints.Length;


/**
 * ClassName: GetActivitysReq <br/>
 * date: 2017年3月20日 下午6:44:23 <br/>
 *
 * @author youhaijun
 * @version 
 * @since JDK 1.6
 */
@ApiModel
public class PhysicalReq {


    @NotNull(message = "订单号不可为空")
    @Length(min=13, max=64)
    private String orderId;//订单号

    @NotNull(message = "用户手机号不可为空")
    @Pattern(regexp = "(^((17[0-9])|(14[0-9])|(13[0-9])|(15[^4,\\\\D])|(18[0,5-9]))\\\\d{8}$)|(^([a-z0-9A-Z]+[-|\\\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\\\.)+[a-zA-Z]{2,}$)", message = "您的支付宝账户必须是手机号或者邮箱,请验证.")
    private String phoneNumber;//用户手机号

    @NotNull(message = "用户名不可为空")
    private String consignee ;//用户名

    @NotNull(message = "收货地址不可为空")
    private String shippingAddress;//收货地址

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getPhoneNumber() {
        return phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public String getConsignee() {
        return consignee;
    }

    public void setConsignee(String consignee) {
        this.consignee = consignee;
    }

    public String getShippingAddress() {
        return shippingAddress;
    }

    public void setShippingAddress(String shippingAddress) {
        this.shippingAddress = shippingAddress;
    }
}

