/**
 * Copyright (c) 2018, duiba.com.cn All Rights Reserved.
 */
package com.duiba.tuia.youtui.web.model.req;

import cn.com.duiba.tuia.activity.center.api.constant.IdType;

/**
 * 描述: 查询奖项列表REQ
 *
 * @version v1.0
 * @auther guopengfei@duiba.com.cn
 * @date 2018/3/30 11:51
 */
public class OptionListReq extends PageQueryReq {

    /* 查询奖项列表的页面类型 */
    /**
     * @see IdType
     */
    private Integer pageType;

    /* 查询奖项列表的页面ID */
    private Long pageId;

    public Integer getPageType() {
        return pageType;
    }

    public void setPageType(Integer pageType) {
        this.pageType = pageType;
    }

    public Long getPageId() {
        return pageId;
    }

    public void setPageId(Long pageId) {
        this.pageId = pageId;
    }

    /**
     * 是否直投页
     *
     * @return
     */
    public Boolean isGuidePage() {
        return pageType != null && pageId != null && pageType.equals(IdType.GUIDEPAGE.getType());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        OptionListReq that = (OptionListReq) o;

        if (pageType != null ? !pageType.equals(that.pageType) : that.pageType != null) return false;
        return pageId != null ? pageId.equals(that.pageId) : that.pageId == null;
    }

    @Override
    public int hashCode() {
        int result = pageType != null ? pageType.hashCode() : 0;
        result = 31 * result + (pageId != null ? pageId.hashCode() : 0);
        return result;
    }
}
