package com.duiba.tuia.youtui.web.model.req;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName:LuckBagRequest.java <br/>
 * 福袋请求
 * 
 * @author gey
 * @date 创建时间：2016年11月17日 上午10:45:49
 * @version 1.0
 * @parameter
 * @since JDK 1.6
 */
public class LuckBagReq {
    
    /** UNKNOWN */
    private static final String UNKNOWN = "unknown";

    /** 点击按钮的用户id */
    private Long   consumerId;

    /** 点击按钮的客户端的UA */
    private String ua;

    /** 承载点击按钮的订单的id，用来判断计费的次数 */
    private String orderId;

    /** 点击按钮的客户端的ip */
    private String ip;

    /** 发生点击事件的app的id */
    private Long   appId;

    /** 产品ID */
    private Long   productId;

    /** 福袋被添加的活动ID */
    private Long   activityId;

    /** 活动标签. */
    private String tag;

    /** 客户端时间戳，毫秒 */
    private Long   timestamp;

    /** 登陆状态（未登录：0，登陆：1） */
    private String loginType;

    /** 按钮埋点号码 */
    private String buttonType;

    /** 细节类型 */
    private String infoType;

    /** 细节 */
    private String info;

    /** 用户使用系统 */
    private String os;

    /** 点击：0，曝光：1，请求：2，发券：3，计费：4 */
    private String type;

    private String userAgent;

    /** 在cookie中写入的设备id */
    private String deviceId;

    /** 使用指纹生成技术产生的指纹 */
    private String fingerPrint;

    /** x,y坐标 */
    private String coordinate;

    /** 浏览器名 */
    private String browserName;

    /** 浏览器版本 */
    private String browserVersion;

    /** 浏览器别名 */
    private String browserAlias;

    /** URL */
    private String url;

    /** url不完全地址 */
    private String urlPattern;

    /** 上一个url */
    private String preUrl;

    /** 上一个url不完全地址 */
    private String preurlPattern;

    /** 当前系统时间 */
    private String time;

    /** 广告位ID */
    private Long   slotId;

    /** 广告ID */
    private Long   advertId;

    /** 执行结果code. */
    private String result;

    /** 执行结果说明. */
    private String message;

    public Long getProductId() {
        return productId;
    }

    public void setProductId(Long productId) {
        this.productId = productId;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public Long getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public String getLoginType() {
        return loginType;
    }

    public void setLoginType(String loginType) {
        this.loginType = loginType;
    }

    public String getButtonType() {
        return buttonType;
    }

    public void setButtonType(String buttonType) {
        this.buttonType = buttonType;
    }

    public String getInfoType() {
        return infoType;
    }

    public void setInfoType(String infoType) {
        this.infoType = infoType;
    }

    public String getInfo() {
        return info;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public String getOs() {
        return os;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getFingerPrint() {
        return fingerPrint;
    }

    public void setFingerPrint(String fingerPrint) {
        this.fingerPrint = fingerPrint;
    }

    public String getCoordinate() {
        return coordinate;
    }

    public void setCoordinate(String coordinate) {
        this.coordinate = coordinate;
    }

    public String getBrowserName() {
        return browserName;
    }

    public void setBrowserName(String browserName) {
        this.browserName = browserName;
    }

    public String getBrowserVersion() {
        return browserVersion;
    }

    public void setBrowserVersion(String browserVersion) {
        this.browserVersion = browserVersion;
    }

    public String getBrowserAlias() {
        return browserAlias;
    }

    public void setBrowserAlias(String browserAlias) {
        this.browserAlias = browserAlias;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrlPattern() {
        return urlPattern;
    }

    public void setUrlPattern(String urlPattern) {
        this.urlPattern = urlPattern;
    }

    public String getPreUrl() {
        return preUrl;
    }

    public void setPreUrl(String preUrl) {
        this.preUrl = preUrl;
    }

    public String getPreurlPattern() {
        return preurlPattern;
    }

    public void setPreurlPattern(String preurlPattern) {
        this.preurlPattern = preurlPattern;
    }

    public String getTime() {
        return time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public Long getSlotId() {
        return slotId;
    }

    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public String getResult() {
        return result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getUserAgent() {
        return userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getTag() {
        return tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public String getUa() {
        return ua;
    }

    public void setUa(String ua) {
        this.ua = ua;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }


    /**
     * 获取User-Agent
     * 
     * @param request
     * @return
     */
    public static String getUserAgent(HttpServletRequest request) {
        String ua = request.getHeader("User-Agent");
        if (ua == null) {
            return UNKNOWN;
        }
        ua = ua.toLowerCase();
        if (ua != null) {
            if (ua.contains("ipad") || ua.contains("iphone") || ua.contains("macintosh")) {
                return "IOS";
            } else if (ua.contains("android")) {
                return "Android";
            }
        }
        return UNKNOWN;
    }

    /**
     * getUserAgent:获取User-Agent
     * 
     * @author clemac
     * @param ua
     * @return
     * @since JDK 1.6
     */
    public static String getUserAgent(String ua) {
        if (ua == null) {
            return UNKNOWN;
        }
        ua = ua.toLowerCase();
        if (ua != null) {
            if (ua.contains("ipad") || ua.contains("iphone") || ua.contains("macintosh")) {
                return "IOS";
            } else if (ua.contains("android")) {
                return "Android";
            }
        }
        return UNKNOWN;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
