/**
 * Project Name:tuia-youtui-web<br>
 * File Name:DoJoinActivityReq.java<br>
 * Package Name:com.duiba.tuia.youtui.web.model.req<br>
 * Date:2017年1月17日下午12:48:42<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */

package com.duiba.tuia.youtui.web.model.req;

import io.swagger.annotations.ApiModel;
import org.apache.commons.lang.builder.ToStringBuilder;

import javax.validation.constraints.NotNull;
import java.util.Map;

/**
 * ClassName: DoJoinPluginToolsReq <br/>
 * Function: 参加插件工具请求参数. <br/>
 * date: 2017年5月12日 下午12:48:42 <br/>
 *
 * @author cdm
 * @version
 * @since JDK 1.6
 */
@ApiModel
public class DoJoinPluginToolsReq {

    /** 插件工具ID. */
    @NotNull(message = "插件工具ID不可为空")
    private Long    pluginToolsId;


    /** 插件工具Type ,由于插件工具与活动共用一个订单表，所以设置一个新的类型2000. */
    private Integer    pluginToolsType;

    /** The slot id. */
    private Long    slotId;


    /** The app id. */
    private Long    appId;

    /** 用户 id. */
    private Long    consumerId;

    /** The ip. */
    private String  ip;

    /** The user agent. */
    private String  userAgent;

    /** The os. */
    private String  os;
    
    private String referer;
    
    /** 设备id*/
    private String deviceId;
    
    /**福袋请求额外的参数*/
    private Map<String,String> paramMap;


    public Long getSlotId() {
        return slotId;
    }

    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    /**
     * Gets the os.
     *
     * @return the os
     */
    public String getOs() {
        return os;
    }

    /**
     * Sets the os.
     *
     * @param os the os
     */
    public void setOs(String os) {
        this.os = os;
    }

    /**
     * Gets the user agent.
     *
     * @return the user agent
     */
    public String getUserAgent() {
        return userAgent;
    }

    /**
     * Sets the user agent.
     *
     * @param userAgent the user agent
     */
    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    /**
     * Gets the ip.
     *
     * @return the ip
     */
    public String getIp() {
        return ip;
    }

    /**
     * Sets the ip.
     *
     * @param ip the ip
     */
    public void setIp(String ip) {
        this.ip = ip;
    }

    /**
     * Gets the consumer id.
     *
     * @return the consumer id
     */
    public Long getConsumerId() {
        return consumerId;
    }

    /**
     * Sets the consumer id.
     *
     * @param consumerId the consumer id
     */
    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    /**
     * Gets the app id.
     *
     * @return the app id
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * Sets the app id.
     *
     * @param appId the app id
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }


    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    
    public String getReferer() {
        return referer;
    }

    
    public void setReferer(String referer) {
        this.referer = referer;
    }

    
    public String getDeviceId() {
        return deviceId;
    }

    
    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    
    public Map<String, String> getParamMap() {
        return paramMap;
    }

    
    public void setParamMap(Map<String, String> paramMap) {
        this.paramMap = paramMap;
    }

    public Long getPluginToolsId() {
        return pluginToolsId;
    }

    public void setPluginToolsId(Long pluginToolsId) {
        this.pluginToolsId = pluginToolsId;
    }

    public Integer getPluginToolsType() {
        return pluginToolsType;
    }

    public void setPluginToolsType(Integer pluginToolsType) {
        this.pluginToolsType = pluginToolsType;
    }
}
