package com.duiba.tuia.youtui.web.model.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.Pattern;
import org.hibernate.validator.constraints.Range;

/**
 * Created by Administrator on 2017/12/13.
 */
@ApiModel
public class ConsumerReq{

    @ApiModelProperty(value = "手机号", required = false)
    @Pattern(regexp = "(^((17[0-9])|(14[0-9])|(13[0-9])|(15[^4,\\\\D])|(18[0,5-9]))\\\\d{8}$)", message = "格式有误，请重新输入")
    private String phone;

    @ApiModelProperty(value = "用户密码", required = false)
    @Pattern(regexp = "/^[a-zA-Z0-9]{6,18}$/", message = "密码格式有误，请重新输入")
    private String password;

    @ApiModelProperty(value = "账户类型，1：现金钱包", required = false)
    @Range(min=0, max=2, message = "账户类型有误，请重新输入")
    private Integer balanceType;

    @ApiModelProperty(value = "初始密码", required = false)
    @Pattern(regexp = "/^[a-zA-Z0-9]{6}$/", message = "密码格式有误，请重新输入")
    private String initialPassword;

    @ApiModelProperty(value = "页面ID", required = false)
    private Long pageId;

    public Long getPageId() {
        return pageId;
    }

    public void setPageId(Long pageId) {
        this.pageId = pageId;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Integer getBalanceType() {
        return balanceType;
    }

    public void setBalanceType(Integer balanceType) {
        this.balanceType = balanceType;
    }

    public String getInitialPassword() {
        return initialPassword;
    }

    public void setInitialPassword(String initialPassword) {
        this.initialPassword = initialPassword;
    }
}
