/**
 * Project Name:tuia-youtui-web<br>
 * File Name:ActivitySkinReq.java<br>
 * Package Name:com.duiba.tuia.youtui.web.model.req<br>
 * Date:2017年2月5日上午10:47:05<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */
package com.duiba.tuia.youtui.web.model.req;

import io.swagger.annotations.ApiModel;

import javax.validation.constraints.NotNull;

import org.apache.commons.lang3.builder.ToStringBuilder;

/**
 * ClassName: ActivitySkinReq <br/>
 * Function: 活动皮肤请求参数. <br/>
 * date: 2017年2月5日 上午10:47:05 <br/>
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
@ApiModel
public class ActivitySkinReq {

    /** 活动ID. */
    @NotNull(message = "活动ID不可为空")
    private Long    activityId;

    /** 模板类型. */
    @NotNull(message = "模板类型不可为空")
    private Integer templateType;

    /**
     * Gets the activity id.
     *
     * @return the activity id
     */
    public Long getActivityId() {
        return activityId;
    }

    /**
     * Sets the activity id.
     *
     * @param activityId the activity id
     */
    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    /**
     * Gets the template type.
     *
     * @return the template type
     */
    public Integer getTemplateType() {
        return templateType;
    }

    /**
     * Sets the template type.
     *
     * @param templateType the template type
     */
    public void setTemplateType(Integer templateType) {
        this.templateType = templateType;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
