package com.duiba.tuia.youtui.web.model.mainmeet;


import cn.com.duiba.tuia.activity.center.api.constant.IdType;
import cn.com.duiba.tuia.activity.center.api.dto.GuidePageRelationDto;

/**
 * 主会场区块数据
 */
public class BlockRsp {
    private Long activityId;
    private Long pluginId;
    private String activityName;
    private String url;
    private String blockName;
    private Boolean havePlugin;
    private String bannerUrl;
    private String stExposure;
    private String stClick;

    public BlockRsp() {
    }

    public BlockRsp(GuidePageRelationDto dto) {
        this.blockName = dto.getBlockName();
        this.havePlugin = false;
        if (IdType.ACTIVITY.getType().equals(dto.getIdType())) {
            this.activityId = dto.getActivityId();
        } else if (IdType.PLUGIN.getType().equals(dto.getIdType())) {
            this.pluginId = dto.getActivityId();
            this.havePlugin = true;
        }
    }

    public Long getActivityId() {
        return activityId;
    }

    public BlockRsp setActivityId(Long activityId) {
        this.activityId = activityId;
        return this;
    }

    public Long getPluginId() {
        return pluginId;
    }

    public BlockRsp setPluginId(Long pluginId) {
        this.pluginId = pluginId;
        return this;
    }

    public String getActivityName() {
        return activityName;
    }

    public BlockRsp setActivityName(String activityName) {
        this.activityName = activityName;
        return this;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getBlockName() {
        return blockName;
    }

    public void setBlockName(String blockName) {
        this.blockName = blockName;
    }

    public Boolean getHavePlugin() {
        return havePlugin;
    }

    public BlockRsp setHavePlugin(Boolean havePlugin) {
        this.havePlugin = havePlugin;
        return this;
    }

    public String getBannerUrl() {
        return bannerUrl;
    }

    public void setBannerUrl(String bannerUrl) {
        this.bannerUrl = bannerUrl;
    }

    public String getStExposure() {
        return stExposure;
    }

    public void setStExposure(String stExposure) {
        this.stExposure = stExposure;
    }

    public String getStClick() {
        return stClick;
    }

    public void setStClick(String stClick) {
        this.stClick = stClick;
    }
}
