package com.duiba.tuia.youtui.web.model.direct;

import com.duiba.tuia.youtui.web.constant.Constants;
import com.duiba.tuia.youtui.web.embed.DcmBuilder;
import com.google.common.collect.Maps;

import cn.com.duiba.tuia.activity.center.api.dto.GuidePageBlockDto;

import com.duiba.tuia.youtui.web.embed.DirectEmbed;
import com.duiba.tuia.youtui.web.embed.DpmBuilder;
import com.duiba.tuia.youtui.web.model.req.DirectPageReq;
import com.duiba.tuia.youtui.web.tool.PathUtil;

import java.util.Map;

/**
 * 直投页自有配置区块 Created by wubo on 2017/8/31.
 */
public class UrlBlock extends Block {


    public UrlBlock(GuidePageBlockDto dto) {
        super(dto);
        super.setUrl(dto.getUrl());
    }

    @Override
    public void buildEmbed(String dsm, int regionNum, int blockNum, Long consumerId, Long appId, String host, Long directPage) {
        super.setDpm(DpmBuilder.directBlockBuild(appId, regionNum, blockNum));
        super.setDcm(DcmBuilder.directUrlBlockBuild(super.getPageId()));
        super.setDsm(dsm);
        super.setEmbedInfo(new DirectEmbed(super.getDcm(), dsm, super.getDpm(), consumerId, appId, host, directPage).buildAdvertEmbed());
    }

    @Override
    public void buildUrl(DirectPageReq req) {
        Map<String,String> params = Maps.newHashMap();
        params.put(Constants.VALUENAME.SLOT_ID, String.valueOf(req.getSlotId()));
        params.put(Constants.VALUENAME.PAGE_ID, String.valueOf(super.getPageId()));
        super.setUrl(PathUtil.getDirectAdvert(req.getHost(), super.getUrl(), params));
    }

}
