package com.duiba.tuia.youtui.web.model.direct;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 直投页区域VO
 * Created by wubo on 2017/8/31.
 */
public class Region implements Serializable{
    /**
     * 区域名称
     */
    private String regionName;

    /**
     * 区域类型
     */
    private Integer regionType;

    private List<Block> blocks;

    private int blockNum = 0;

    public Region() {
    }

    public Region(String regionName, Integer regionType) {
        this.regionName = regionName;
        this.regionType = regionType;
    }

    public String getRegionName() {
        return regionName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public Integer getRegionType() {
        return regionType;
    }

    public void setRegionType(Integer regionType) {
        this.regionType = regionType;
    }

    public List<Block> getBlocks() {
        return blocks;
    }

    public void setBlocks(List<Block> blocks) {
        this.blocks = blocks;
    }

    public int getBlockNum() {
        return blockNum;
    }

    public Region addBlock(Block block) {
        if (blocks == null) {
            blocks = new ArrayList<>();
        }
        blocks.add(block);
        blockNum++;
        return this;
    }

}
