package com.duiba.tuia.youtui.web.model.direct;

import cn.com.duiba.tuia.activity.center.api.constant.PageType;
import com.duiba.tuia.youtui.web.embed.DcmBuilder;
import com.duiba.tuia.youtui.web.embed.DirectEmbed;
import com.duiba.tuia.youtui.web.embed.DpmBuilder;
import com.duiba.tuia.youtui.web.model.req.DirectPageReq;

import cn.com.duiba.tuia.activity.center.api.dto.GuidePageBlockDto;
import com.duiba.tuia.youtui.web.model.req.IndexReq;
import com.duiba.tuia.youtui.web.tool.PathUtil;

/**
 * 主会场区块 Created by wubo on 2017/9/27.
 */
public class MainMeetBlock extends Block {

    private Long mainMeetId;

    public Long getMainMeetId() {
        return mainMeetId;
    }

    public void setMainMeetId(Long mainMeetId) {
        this.mainMeetId = mainMeetId;
    }

    public MainMeetBlock(GuidePageBlockDto dto,Long mainMeetId) {
        super(dto);
        this.mainMeetId = mainMeetId;
    }

    @Override
    public void buildEmbed(String dsm, int regionNum, int blockNum, Long consumerId, Long appId, String host,Long directPage) {
        super.setDpm(DpmBuilder.directBlockBuild(appId, regionNum, blockNum));
        super.setDcm(DcmBuilder.directMainMeetBlockBuild(mainMeetId,super.getPageId()));
        super.setDsm(dsm);
        DirectEmbed directEmbed = new DirectEmbed(super.getDcm(), dsm, super.getDpm(), consumerId, appId, host,directPage);
        super.setEmbedInfo(directEmbed.buildAdvertEmbed());
    }

    @Override
    public void buildUrl(DirectPageReq req) {
        IndexReq indexReq = new IndexReq();
        indexReq.setId(super.getPageId());
        indexReq.setAppKey(req.getAppKey());
        indexReq.setLogin(req.getLogin());
        indexReq.setSlotId(req.getSlotId());
        indexReq.setDeviceId(req.getDeviceId());
        indexReq.setDcm(super.getDcm());
        indexReq.setDsm(super.getDsm());
        indexReq.setDpm(super.getDpm());
        indexReq.setHost(req.getHost());
        super.setUrl(PathUtil.getGuidePageUrl(mainMeetId, indexReq, PageType.MAINMEET.getCode()));

    }
}
