package com.duiba.tuia.youtui.web.model.direct;

import cn.com.duiba.tuia.activity.center.api.dto.GuidePageBlockDto;
import com.duiba.tuia.youtui.web.embed.DcmBuilder;
import com.duiba.tuia.youtui.web.embed.DirectEmbed;
import com.duiba.tuia.youtui.web.embed.DpmBuilder;
import com.duiba.tuia.youtui.web.model.req.DirectPageReq;
import com.duiba.tuia.youtui.web.model.req.IndexReq;
import com.duiba.tuia.youtui.web.tool.PathUtil;

/**
 * 直投页活动区块 Created by wubo on 2017/8/31.
 */
public class GameBlock extends Block {

    /**
     * 游戏id
     */
    private Long             gameId;
    /**
     * 游戏标题
     */
    private String           title;
    /**
     * 游戏图
     */
    private String           bannerUrl;


    public GameBlock(GuidePageBlockDto dto) {
        super(dto);
        this.gameId = Long.valueOf(dto.getRelationIds());
        this.title = dto.getBlockName();
        this.bannerUrl = dto.getImage();
    }

    public GameBlock(GuidePageBlockDto dto, Long activityId) {
        super(dto);
        this.gameId = activityId;
    }

    @Override
    public void buildEmbed(String dsm, int regionNum, int blockNum, Long consumerId, Long appId, String host, Long directPage) {
        super.setDcm(DcmBuilder.directGameBlockBuild(gameId, super.getPageId()));
        super.setDsm(dsm);
        super.setDpm(DpmBuilder.directBlockBuild(appId, regionNum, blockNum));
        DirectEmbed embed = new DirectEmbed(super.getDcm(), dsm, super.getDpm(), consumerId, appId, host,directPage);
        super.setEmbedInfo(embed.buildAdvertEmbed());
    }

    @Override
    public void buildUrl(DirectPageReq req) {
        IndexReq indexReq = new IndexReq();
        indexReq.setId(this.getGameId());
        indexReq.setAppKey(req.getAppKey());
        indexReq.setLogin(req.getLogin());
        indexReq.setSlotId(req.getSlotId());
        indexReq.setDeviceId(req.getDeviceId());
        indexReq.setDcm(super.getDcm());
        indexReq.setDsm(super.getDsm());
        indexReq.setDpm(super.getDpm());
        indexReq.setHost(req.getHost());
        indexReq.setPageId(req.getPageId());
        super.setUrl(PathUtil.getGameUrl(indexReq));
    }

    public Long getGameId() {
        return gameId;
    }

    public void setGameId(Long gameId) {
        this.gameId = gameId;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getBannerUrl() {
        return bannerUrl;
    }

    public void setBannerUrl(String bannerUrl) {
        this.bannerUrl = bannerUrl;
    }


}
