package com.duiba.tuia.youtui.web.model.direct;

import com.duiba.tuia.youtui.web.biz.interfaces.ImageBusiness;
import com.duiba.tuia.youtui.web.model.req.DirectPageReq;

import java.io.Serializable;
import java.util.Map;

import cn.com.duiba.tuia.activity.center.api.dto.GuidePageBlockDto;
import com.duiba.tuia.youtui.web.tool.DomainUtil;

/**
 * 直投页区块
 * Created by wubo on 2017/8/31.
 */
public abstract class Block implements Serializable,ImageBusiness {

    /**
     * 区块id
     */
    private Long id;
    /**
     * 区块名称
     */
    private String blockName;

    /**
     * 区块类型
     */
    private Integer blockType;

    /**
     * 访问链接
     */
    private String url;

    /**
     * 页面id
     */
    private Long pageId;

    /**
     * 区块图片
     */
    private String image;

    /**
     * 埋点信息
     */
    private Map<String,String> embedInfo;

    private String dpm;
    private String dcm;
    private String dsm;

    private Boolean isReward;

    private Block() {

    }


    public Block(GuidePageBlockDto dto) {
        this.id = dto.getId();
        this.blockType = dto.getBlockType();
        this.blockName = dto.getBlockName();
        this.pageId = dto.getPageId();
        this.image = dto.getImage();
        this.isReward = dto.getIsReward();
    }

    public Boolean getIsReward() {
        return isReward;
    }

    public void setIsReward(Boolean isReward) {
        this.isReward = isReward;
    }

    /**
     * 构建埋点数据
     * @param dsm dsm
     * @param regionNum 区域索引，作为dpm c位
     * @param blockNum 区块索引，作为dpm d位
     * @param consumerId 用户id
     * @param appId appId
     * @param host 域名
     */
    public abstract void buildEmbed(String dsm,int regionNum,int blockNum,Long consumerId,
                                    Long appId,String host,Long directPage);

    /**
     * 生成访问url
     * @param req  请求参数
     */
    public abstract void buildUrl(DirectPageReq req);

    /**
     * 替换图片url中的域名
     * @param domain 域名
     */
    public void replaceDomain(String domain){
        this.image = DomainUtil.replaceDomain(image, domain);
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getBlockName() {
        return blockName;
    }

    public void setBlockName(String blockName) {
        this.blockName = blockName;
    }

    public Integer getBlockType() {
        return blockType;
    }

    public void setBlockType(Integer blockType) {
        this.blockType = blockType;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Long getPageId() {
        return pageId;
    }

    public void setPageId(Long pageId) {
        this.pageId = pageId;
    }

    public Map<String, String> getEmbedInfo() {
        return embedInfo;
    }

    public void setEmbedInfo(Map<String, String> embedInfo) {
        this.embedInfo = embedInfo;
    }

    public String getDpm() {
        return dpm;
    }

    public void setDpm(String dpm) {
        this.dpm = dpm;
    }

    public String getDcm() {
        return dcm;
    }

    public void setDcm(String dcm) {
        this.dcm = dcm;
    }

    public String getDsm() {
        return dsm;
    }

    public void setDsm(String dsm) {
        this.dsm = dsm;
    }

    public String getImage() {
        return image;
    }

    public void setImage(String image) {
        this.image = image;
    }
}
