package com.duiba.tuia.youtui.web.model.direct;

import cn.com.duiba.tuia.activity.center.api.dto.GuidePageBlockDto;
import com.duiba.tuia.youtui.web.constant.Constants;
import com.duiba.tuia.youtui.web.embed.DcmBuilder;
import com.duiba.tuia.youtui.web.embed.DirectEmbed;
import com.duiba.tuia.youtui.web.embed.DpmBuilder;
import com.duiba.tuia.youtui.web.model.req.DirectPageReq;
import com.duiba.tuia.youtui.web.tool.PathUtil;
import com.google.common.collect.Maps;
import org.apache.commons.lang.StringUtils;

import java.util.Map;

/**
 * 直投页广告区块 Created by wubo on 2017/8/31.
 */
public class AdvertBlock extends Block {


    /**
     * 广告id
     */
    private Long   adId;

    /**
     * 配置包
     */
    private Long   packageId;


    private String effectiveMainType;

    public AdvertBlock(GuidePageBlockDto dto) {
        super(dto);
    }

    public AdvertBlock(GuidePageBlockDto dto, Long packageId) {
        super(dto);

        this.packageId = packageId;
    }

    @Override
    public void buildEmbed(String dsm, int regionNum, int blockNum, Long consumerId, Long appId, String host, Long directPage) {
        super.setDcm(DcmBuilder.directBlockBuild(adId, super.getPageId()));
        super.setDsm(dsm);
        super.setDpm(DpmBuilder.directBlockBuild(appId, regionNum, blockNum));
        DirectEmbed directEmbed = new DirectEmbed(super.getDcm(), super.getDsm(), super.getDpm(), consumerId, appId, host,directPage);
        super.setEmbedInfo(directEmbed.buildAdvertEmbed());
    }

    @Override
    public void buildUrl(DirectPageReq req) {
        Map<String, String> params = Maps.newHashMap();
        params.put(Constants.VALUENAME.ADVERT_ID, String.valueOf(adId));
        params.put(Constants.VALUENAME.SLOT_ID, String.valueOf(req.getSlotId()));
        params.put(Constants.VALUENAME.PAGE_ID, String.valueOf(super.getPageId()));
        params.put(Constants.VALUENAME.PACKAGE_ID, String.valueOf(packageId));
        params.put(Constants.KEY.DSM, super.getDsm());
        params.put(Constants.KEY.DCM, super.getDcm());
        params.put(Constants.KEY.DPM, super.getDpm());
        if (StringUtils.isNotBlank(effectiveMainType)) {
            params.put("effectiveMainType", effectiveMainType);
        }
        super.setUrl(PathUtil.getDirectAdvert(req.getHost(), super.getUrl(), params));
    }



    public Long getAdId() {
        return adId;
    }

    public AdvertBlock setAdId(Long adId) {
        this.adId = adId;
        return this;
    }

    public String getEffectiveMainType() {
        return effectiveMainType;
    }

    public AdvertBlock setEffectiveMainType(String effectiveMainType) {
        this.effectiveMainType = effectiveMainType;
        return this;
    }

    public Long getPackageId() {
        return packageId;
    }

    public void setPackageId(Long packageId) {
        this.packageId = packageId;
    }
}
