/**
 * Project Name:tuia-youtui-web<br>
 * File Name:UserAccount.java<br>
 * Package Name:com.duiba.tuia.youtui.web.model<br>
 * Date:2017年1月22日下午3:33:46<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */

package com.duiba.tuia.youtui.web.model;

import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;

/**
 * ClassName: UserAccount <br/>
 * Function: 用户信息. <br/>
 * date: 2017年1月22日 下午3:33:46 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public class UserAccount implements Serializable {

    private static final long serialVersionUID = 1L;

    /** The app id. */
    private Long              appId;

    /** The user id. */
    private Long              userId;

    /** The partner user id. */
    private String            partnerUserId;

    /** 登录状态
     * */
    private Boolean loginStatus;

    /**
     * Creates a new instance of UserAccount.
     *
     * @param appId
     * @param partnerUserId
     */

    public UserAccount(Long appId, String partnerUserId) {
        super();
        this.appId = appId;
        this.partnerUserId = partnerUserId;
        this.loginStatus = false;//默认未登录
    }

    /**
     * Creates a new instance of UserAccount.
     */

    public UserAccount() {
        super();
        this.loginStatus = false;//默认未登录
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getPartnerUserId() {
        return partnerUserId;
    }

    public void setPartnerUserId(String partnerUserId) {
        this.partnerUserId = partnerUserId;
    }

    public Boolean getLoginStatus() {
        return loginStatus;
    }

    public void setLoginStatus(Boolean loginStatus) {
        this.loginStatus = loginStatus;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
