package com.duiba.tuia.youtui.web.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringUtils;

import cn.com.duiba.wolf.perf.timeprofile.RequestTool;

/**
 * ClassName: RequestParams <br/>
 * date: 2016年12月5日 下午7:52:07 <br/>.
 *
 * @version
 * @since JDK 1.6
 */
public class RequestParams implements Serializable{
	
	/** The Constant serialVersionUID. */
	private static final long serialVersionUID = -714078552503355128L;
	
	/** The user agent. */
	private String userAgent;
	
	/** The consumer id. */
	private Long consumerId;
	
	/** The ip. */
	private String ip; 
	
	/** The os. */
	private String os;
	
	/** The transer. */
	private String transer;
	
	/** The cookies. */
	private Map<String, String> cookies = new HashMap<>();
	
	/**
	 * Gets the transer.
	 *
	 * @return the transer
	 */
	public String getTranser() {
		return transer;
	}

	/**
	 * Sets the transer.
	 *
	 * @param transer the transer
	 */
	public void setTranser(String transer) {
		this.transer = transer;
	}

	/**
	 * Gets the user agent.
	 *
	 * @return the user agent
	 */
	public String getUserAgent() {
		return userAgent;
	}

	/**
	 * Sets the user agent.
	 *
	 * @param userAgent the user agent
	 */
	public void setUserAgent(String userAgent) {
		this.userAgent = userAgent;
	}

	/**
	 * Gets the consumer id.
	 *
	 * @return the consumer id
	 */
	public Long getConsumerId() {
		return consumerId;
	}

	/**
	 * Sets the consumer id.
	 *
	 * @param consumerId the consumer id
	 */
	public void setConsumerId(Long consumerId) {
		this.consumerId = consumerId;
	}

	/**
	 * Gets the ip.
	 *
	 * @return the ip
	 */
	public String getIp() {
		return ip;
	}

	/**
	 * Sets the ip.
	 *
	 * @param ip the ip
	 */
	public void setIp(String ip) {
		this.ip = ip;
	}

	/**
	 * Gets the os.
	 *
	 * @return the os
	 */
	public String getOs() {
		return os;
	}
	
	/**
	 * Sets the os.
	 *
	 * @param os the os
	 */
	public void setOs(String os) {
		this.os = os;
	}
	
	/**
	 * getCookies:(这里用一句话描述这个方法的作用). <br/>
	 *
	 * @param name the name
	 * @return the cookies
	 * @since JDK 1.6
	 */
	public String getCookies(String name) {
		return this.cookies.get(name);
	}

	/**
	 * setCookies:(这里用一句话描述这个方法的作用). <br/>
	 *
	 * @param request the cookies
	 * @since JDK 1.6
	 */
	public void setCookies(HttpServletRequest request) {
		Cookie[] getCookies = request.getCookies();
		if (getCookies != null) {
			for (int i = 0; i < getCookies.length; i++) {
				Cookie c = getCookies[i];
				this.cookies.put(c.getName(), c.getValue());
			}
		}
	}

	/**
	 * parse:(这里用一句话描述这个方法的作用). <br/>
	 *
	 * @param request the request
	 * @param consumerId the consumer id
	 * @return the request params
	 * @since JDK 1.6
	 */
	public static RequestParams parse(HttpServletRequest request, Long consumerId) {
		RequestParams rp = new RequestParams();
		rp.setUserAgent(request.getHeader("User-Agent"));
		rp.setIp(RequestTool.getIpAddr(request));
		rp.setConsumerId(consumerId);
		rp.setCookies(request);
		rp.setOs(RequestTool.getOSNew(request));
		rp.setTranser(getTransfer(request));
		return rp;
	}
	
	/**
	 * Gets the transfer.
	 *
	 * @param request the request
	 * @return the transfer
	 */
	public static String getTransfer(HttpServletRequest request){
	    if(StringUtils.isNotBlank(request.getParameter("transfer"))){
	        return request.getParameter("transfer");
	    }
        Cookie[] cs=request.getCookies();
        if(cs!=null){
            for(Cookie c:cs){
                if("transfer".equals(c.getName())){
                    return c.getValue();
                }
            }
        }
        return null;
    }

	/**
	 * Gets the cookies.
	 *
	 * @return the cookies
	 */
	public Map<String, String> getCookies() {
		return cookies;
	}

	/**
	 * Sets the cookies.
	 *
	 * @param cookies the cookies
	 */
	public void setCookies(Map<String, String> cookies) {
		this.cookies = cookies;
	}
	
	/**
	 * getUa:(这里用一句话描述这个方法的作用). <br/>
	 *
	 * @param ua the ua
	 * @return the ua
	 * @since JDK 1.6
	 */
	public static String getUa(String ua){
		if(ua==null){
			return "unknown";
		}
		ua=ua.toLowerCase();
		if(ua!=null){
			if(ua.contains("ipad") || ua.contains("iphone") || ua.contains("macintosh")){
				return "IOS";
			}else if(ua.contains("android")){
				return "Android";
			}
		}
		return "unknown";
	}
}