/**
 * Project Name:tuia-youtui-web<br>
 * File Name:RecordGeneralVO.java<br>
 * Package Name:com.duiba.tuia.youtui.web.model<br>
 * Date:2017年2月8日下午2:09:04<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */

package com.duiba.tuia.youtui.web.model;

import com.duiba.tuia.youtui.web.biz.interfaces.ImageBusiness;
import com.duiba.tuia.youtui.web.tool.DomainUtil;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.Map;

/**
 * ClassName: RecordGeneralVO <br/>
 * 兑换记录概要VO date: 2017年2月8日 下午2:09:04 <br/>
 *
 * @author leiliang
 * @since JDK 1.6
 */
public class RecordGeneralVO implements Serializable, ImageBusiness {

    /**
     * @since JDK 1.6
     */
    private static final long serialVersionUID = -8770895767347228808L;

    private String title;                                   // 商品标题

    private String thumbnailPng;                            // 缩略图

    private String endValid;                                // 失效时间

    private int fee;                                        //广告费用

    private String orderId;                                      // 订单编号

    private Long activityId; // 活动ID

    private int remainDay;                                // 剩余天数

    private String statusTips;//支付宝订单状态描述

    private Integer status;//支付宝订单状态描述

    private String remainTime;//剩余过期时间

    private Long advertId;  //广告ID

    private String prizeType;

    private Map<String, String> stmInfos; //埋点数据

    public Map<String, String> getStmInfos() {
        return stmInfos;
    }

    public void setStmInfos(Map<String, String> stmInfos) {
        this.stmInfos = stmInfos;
    }

    public String getPrizeType() {
        return prizeType;
    }

    public void setPrizeType(String prizeType) {
        this.prizeType = prizeType;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public int getFee() {
        return fee;
    }

    public void setFee(int fee) {
        this.fee = fee;
    }

    public String getRemainTime() {
        return remainTime;
    }

    public void setRemainTime(String remainTime) {
        this.remainTime = remainTime;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getStatusTips() {
        return statusTips;
    }

    public void setStatusTips(String statusTips) {
        this.statusTips = statusTips;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getThumbnailPng() {
        return thumbnailPng;
    }

    public void setThumbnailPng(String thumbnailPng) {
        this.thumbnailPng = thumbnailPng;
    }

    public String getEndValid() {
        return endValid;
    }

    public void setEndValid(String endValid) {
        this.endValid = endValid;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }


    public int getRemainDay() {
        return remainDay;
    }


    public void setRemainDay(int remainDay) {
        this.remainDay = remainDay;
    }


    public String getOrderId() {
        return orderId;
    }


    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    @Override
    public void replaceDomain(String domain) {
        this.thumbnailPng = DomainUtil.replaceDomain(thumbnailPng, domain);
    }


}
