/**
 * Project Name:tuia-youtui-web<br>
 * File Name:RecordDetailVO.java<br>
 * Package Name:com.duiba.tuia.youtui.web.model<br>
 * Date:2017年2月8日下午2:13:56<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */

package com.duiba.tuia.youtui.web.model;


import cn.com.duiba.tuia.activity.center.api.dto.req.VirtualContext;

import java.io.Serializable;
import java.util.List;

/**
 * ClassName: RecordDetailVO <br/>
 * 兑换记录详情VO. <br/>
 * date: 2017年2月8日 下午2:13:56 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public class RecordDetailVO extends RecordGeneralVO  {

    /**
     * @since JDK 1.6
     */
    private static final long serialVersionUID = -769650237309198986L;

    private String            bannerPng;                              // 详情页

    private String            couponRemark;                           // 奖品说明

    private String            couponDetailRemark;                     // 详情说明

    private String            couponInfo;                             // 券说明

    private String            linkUrl;                                // 券链接

    private String            buttonText;                             // 按钮文案

    private String            codeContent;                            // 券码

    private String            codePasswd;                             // 券密码

    private String            stmInfo;                                // 详情页曝光买点

    private String            iosDownloadUrl;

    private String            androidDownloadUrl;

    private Boolean           showUse;
    
    private Long              activityId;

    private String amount;                          //支付宝红包中奖金额

    private String alipayAccount;                   //支付宝账户

    private  String alipayName;                     //支付宝账户认证名称

    private String shippingAddress;                 //收货地址

    private String expressNumber;                   //快递单号
    private String express;                         //快递公司

    private List<VirtualContext> optionWinnerInfos; //中奖用户信息

    private Integer subType;                        //虚拟奖品子类型

    private String awardAmount;                     //虚拟奖品金额

    private String valueUnit;                       //虚拟奖品单位

    private DetailContactInfo detailContactInfo;                //客服信息

    public DetailContactInfo createDetailContactInfo() {
        this.detailContactInfo = new DetailContactInfo();
        return this.detailContactInfo;
    }

    public DetailContactInfo getDetailContactInfo() {
        return detailContactInfo;
    }

    public void setDetailContactInfo(DetailContactInfo detailContactInfo) {
        this.detailContactInfo = detailContactInfo;
    }

    public String getValueUnit() {
        return valueUnit;
    }

    public void setValueUnit(String valueUnit) {
        this.valueUnit = valueUnit;
    }

    public String getCouponDetailRemark() {
        return couponDetailRemark;
    }

    public void setCouponDetailRemark(String couponDetailRemark) {
        this.couponDetailRemark = couponDetailRemark;
    }

    public String getAwardAmount() {
        return awardAmount;
    }

    public void setAwardAmount(String awardAmount) {
        this.awardAmount = awardAmount;
    }

    public Integer getSubType() {
        return subType;
    }

    public void setSubType(Integer subType) {
        this.subType = subType;
    }

    public List<VirtualContext> getOptionWinnerInfos() {
        return optionWinnerInfos;
    }

    public void setOptionWinnerInfos(List<VirtualContext> optionWinnerInfos) {
        this.optionWinnerInfos = optionWinnerInfos;
    }

    public String getShippingAddress() {
        return shippingAddress;
    }

    public void setShippingAddress(String shippingAddress) {
        this.shippingAddress = shippingAddress;
    }

    public String getExpressNumber() {
        return expressNumber;
    }

    public void setExpressNumber(String expressNumber) {
        this.expressNumber = expressNumber;
    }

    public String getExpress() {
        return express;
    }

    public void setExpress(String express) {
        this.express = express;
    }

    public String getAmount() {
        return amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getAlipayAccount() {
        return alipayAccount;
    }

    public void setAlipayAccount(String alipayAccount) {
        this.alipayAccount = alipayAccount;
    }

    public String getAlipayName() {
        return alipayName;
    }

    public void setAlipayName(String alipayName) {
        this.alipayName = alipayName;
    }

    public String getBannerPng() {
        return bannerPng;
    }

    public void setBannerPng(String bannerPng) {
        this.bannerPng = bannerPng;
    }

    public String getCouponRemark() {
        return couponRemark;
    }

    public void setCouponRemark(String couponRemark) {
        this.couponRemark = couponRemark;
    }

    public String getCouponInfo() {
        return couponInfo;
    }

    public void setCouponInfo(String couponInfo) {
        this.couponInfo = couponInfo;
    }

    public String getLinkUrl() {
        return linkUrl;
    }

    public void setLinkUrl(String linkUrl) {
        this.linkUrl = linkUrl;
    }

    public String getButtonText() {
        return buttonText;
    }

    public void setButtonText(String buttonText) {
        this.buttonText = buttonText;
    }

    public String getCodeContent() {
        return codeContent;
    }

    public void setCodeContent(String codeContent) {
        this.codeContent = codeContent;
    }

    public String getCodePasswd() {
        return codePasswd;
    }

    public void setCodePasswd(String codePasswd) {
        this.codePasswd = codePasswd;
    }

    public String getStmInfo() {
        return stmInfo;
    }

    public void setStmInfo(String stmInfo) {
        this.stmInfo = stmInfo;
    }

    
    public String getIosDownloadUrl() {
        return iosDownloadUrl;
    }

    
    public void setIosDownloadUrl(String iosDownloadUrl) {
        this.iosDownloadUrl = iosDownloadUrl;
    }

    
    public String getAndroidDownloadUrl() {
        return androidDownloadUrl;
    }

    
    public void setAndroidDownloadUrl(String androidDownloadUrl) {
        this.androidDownloadUrl = androidDownloadUrl;
    }

    
    public Boolean getShowUse() {
        return showUse;
    }

    
    public void setShowUse(Boolean showUse) {
        this.showUse = showUse;
    }

    @Override
    public Long getActivityId() {
        return activityId;
    }

    @Override
    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }


    public class DetailContactInfo implements Serializable {
        private static final long serialVersionUID = -7526347469276803116L;

        /** 是否展示奖品详情-客服信息 0:关闭 1:打开 */
        private Boolean             isOpenOptionDetail;
        /** 奖品详情页客服电话 */
        private String              optionDetailPhone;

        public Boolean getIsOpenOptionDetail() {
            return isOpenOptionDetail;
        }

        public void setIsOpenOptionDetail(Boolean isOpenOptionDetail) {
            this.isOpenOptionDetail = isOpenOptionDetail;
        }

        public String getOptionDetailPhone() {
            return optionDetailPhone;
        }

        public void setOptionDetailPhone(String optionDetailPhone) {
            this.optionDetailPhone = optionDetailPhone;
        }
    }
}
