package com.duiba.tuia.youtui.web.model;

import cn.com.duiba.tuia.activity.center.api.constant.LayerSkinType;
import cn.com.duiba.tuia.activity.center.api.dto.LayerSkinDto;
import cn.com.duiba.wolf.utils.BeanUtils;

import java.io.Serializable;

/**
 * Created by wubo on 2017/8/16.
 */
public class LayerVO implements Serializable {

    /**
     * 
     */
    private static final long serialVersionUID = -4433871631256150721L;

    /**
     * id
     */
    private Long              id;

    /**
     * 皮肤名称
     */
    private String            skinName;

    /**
     * 皮肤类型
     */
    private Integer           skinType;

    /**
     * 皮肤类型名称
     */
    private String            skinTypeName;

    /**
     * 皮肤代码
     */
    private String            code;

    /**
     * 图片
     */
    private String            image;

    public LayerVO() {

    }

    public LayerVO(LayerSkinDto dto) {
        BeanUtils.copy(dto, this);
        if (dto.getSkinType() != null) {
            this.skinTypeName = LayerSkinType.getDescByType(dto.getSkinType());

        }
    }

    public LayerSkinDto toDto() {
        return BeanUtils.copy(this, LayerSkinDto.class);
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getSkinName() {
        return skinName;
    }

    public void setSkinName(String skinName) {
        this.skinName = skinName;
    }

    public Integer getSkinType() {
        return skinType;
    }

    public void setSkinType(Integer skinType) {
        this.skinType = skinType;
    }

    public String getSkinTypeName() {
        return skinTypeName;
    }

    public void setSkinTypeName(String skinTypeName) {
        this.skinTypeName = skinTypeName;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getImage() {
        return image;
    }

    public void setImage(String image) {
        this.image = image;
    }
}
