package com.duiba.tuia.youtui.web.model;

import java.math.BigDecimal;
import java.util.concurrent.atomic.LongAdder;

public class ActivityCount {

    private static ActivityCount count = null;

    public static ActivityCount appear() {
        return count;
    }

    public static ActivityCount reset() {
        count = new ActivityCount();
        return count;
    }
    private LongAdder indexCount;
    private LongAdder joinCount;

    public ActivityCount() {
        indexCount = new LongAdder();
        joinCount = new LongAdder();
    }

    public void indexCount() {
        indexCount.increment();
    }

    public void joinCount() {
        joinCount.increment();
    }

    public double joinRate() {
        if (indexCount.longValue() == 0L) {
            return 0;
        }

        return BigDecimal.valueOf(joinCount.longValue() * 100).divide(BigDecimal.valueOf(indexCount.doubleValue()), 2, BigDecimal.ROUND_DOWN).doubleValue();
    }

    public LongAdder getIndexCount() {
        return indexCount;
    }

    public void setIndexCount(LongAdder indexCount) {
        this.indexCount = indexCount;
    }

    public LongAdder getJoinCount() {
        return joinCount;
    }

    public void setJoinCount(LongAdder joinCount) {
        this.joinCount = joinCount;
    }

}
