/**
 * Project Name:tuia-youtui-web
 * File Name:StatActivityNestLog.java
 * Package Name:com.duiba.tuia.youtui.web.log
 * Date:2017年2月16日下午4:16:51
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package com.duiba.tuia.youtui.web.log;

import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.alibaba.fastjson.JSONObject;
import com.duiba.tuia.youtui.web.constant.TimeFormat;

/**
 * ClassName:StatActivityNestLog <br/>
 * Date:     2017年2月16日 下午4:16:51 <br/>.
 *
 * @author   zp
 * @version
 * @since    JDK 1.6
 * @see
 */
public class StatActivityNestLog {
    
    /** The log. */
    private static Logger log = LoggerFactory.getLogger(StatActivityNestLog.class);
    
    /**
     * The Constructor.
     */
    private StatActivityNestLog() {}
    
    /**
     * log:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param activityId the activity id
     * @param appId the app id
     * @param consumerId the consumer id
     * @since JDK 1.6
     */
    public static void log(Long activityId,Long appId,Long consumerId) {
        try {
            String str = format(activityId, appId, consumerId);
            log.info(str);
        } catch (Exception e) {
            log.error("StatActivityNestLog 失败",e);
        }
    }

    /**
     * Format.
     *
     * @param activityId the activity id
     * @param appId the app id
     * @param consumerId the consumer id
     * @return the string
     */
    private static String format(Long activityId,Long appId,Long consumerId) {
        JSONObject json = new JSONObject();
        json.put("activityId", activityId);
        json.put("appId", appId);
        json.put("consumerId", consumerId);
        json.put("logTime", new DateTime().toString(TimeFormat.YYYY_MM_DD_HH_MM_SS));
        return json.toJSONString();
    }
}

