
/**
 * Project Name:tuia-youtui-web<br>
 * File Name:LogWrite.java<br>
 * Package Name:com.duiba.tuia.youtui.web.log<br>
 * Date:2017年2月10日下午4:49:05<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 *
 */

package com.duiba.tuia.youtui.web.log;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;


/**
 * ClassName: LogWrite <br/>
 * Function: 内部日志注解. <br/>
 * date: 2017年2月10日 下午4:49:05 <br/>
 *
 * @author youhaijun
 * @version 
 * @since JDK 1.6
 */
@Target(value = { ElementType.METHOD })
@Retention(value = RetentionPolicy.RUNTIME)
@Documented
@Inherited
public @interface LogWrite {

    /**
     * 模块名称.
     *
     * @return the string
     */
    String modelName() default "";
    
    /**
     * 操作名称.
     *
     * @return the string
     */
    String option() default "";
    
    /**
     * 需要忽略的参数.
     *
     * @return the string[]
     */
    String[] ignoreParams() default {};
}

