package com.duiba.tuia.youtui.web.handle.prize;

import com.duiba.tuia.youtui.web.handle.FilterChain;
import com.duiba.tuia.youtui.web.handle.FilterHandle;
import com.duiba.tuia.youtui.web.handle.FilterParams;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 在这里注册 奖品实发 的filter
 *
 * Created by 清郎 on 2018/01/31.
 */
@Component
public class PrizeFilterHandle extends FilterHandle implements InitializingBean{

    @Autowired
    private UserDayLimitFilter userDayLimitFilter;

    @Override
    public void afterPropertiesSet() {
        // 注册
        this.register(userDayLimitFilter);
    }

    private void register(PrizeFilter... prizeFilters) {
        for (PrizeFilter prizeFilter : prizeFilters) {
            prizeFilter.configPrizes();
        }
        super.register(prizeFilters);
    }

    @Override
    public boolean doFilter(FilterParams filterParams) {
        for (FilterChain filter : super.filters) {
            if (filter instanceof PrizeFilter) {
                if (((PrizeFilter) filter).checkPrize(filterParams.getPrizeType()) && filter.doFilter(filterParams))
                    return true;
            } else {
                if (filter.doFilter(filterParams)) {
                    return true;
                }
            }
        }
        return false;
    }

}
