package com.duiba.tuia.youtui.web.handle.prize;

import cn.com.duiba.tuia.activity.center.api.constant.ActivityOptionType;
import cn.com.duiba.tuia.activity.center.api.constant.AlipayType;
import com.duiba.tuia.youtui.web.handle.FilterParams;
import com.duiba.tuia.youtui.web.service.ActivityService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AwardLimitFilter extends PrizeFilter {

    @Autowired
    private ActivityService activityService;

    @Override
    protected void configPrizes() {
        super.configPrizes(ActivityOptionType.TYPE_VIRTUAL);
    }

    @Override
    public boolean doFilter(FilterParams filterParams) {
        Long optionId = filterParams.getOptionId();
        Integer awardLimit = filterParams.getAwardLimit();
        String deviceId = filterParams.getDeviceId();
        String ip = filterParams.getIp();
        String userId = filterParams.getUserId();

        String user = deviceId;


        //逻辑：虚拟奖品api类型，如果媒体有传userId,则依据媒体的userId做用户限制
        if (AlipayType.isVirtualApi(filterParams.getAlipayType()) && StringUtils.isNotBlank(filterParams.getUserId())) {
            user = userId + "-" + filterParams.getAppId();
        }

        if (awardLimit == null) {
            return false;
        }
        if (awardLimit == 1) {
            return activityService.isHaveWonPrizeDay(optionId, user, ip);
        }

        if (awardLimit == 2) {
            return activityService.isHaveWonPrizeWeek(optionId, user, ip);
        }

        return false;
    }

    @Override
    public int getOffset() {
        return 1;
    }
}
