package com.duiba.tuia.youtui.web.handle;

import cn.com.duiba.tuia.activity.center.api.dto.ActivityOptionDto;
import com.duiba.tuia.youtui.web.model.req.DoJoinActivityReq;

/**
 * 统一参数类
 *
 * 感觉这个参数类 是个败笔，暂时没想到好的通用的方式
 * Created by 清郎 on 2018/01/31.
 */
public class FilterParams {
    private Long slotId;
    private Long optionId;
    private Long consumerId;
    private Long appId;
    private Long activityId;//活动id
    private Integer activityType;//活动类型
    private String prizeType;//奖品类型
    private String deviceId;//用户设备id
    private String userId;//媒体用户（部分媒体会传）
    private String ip;//用户ip
    private Integer amount;//订单中奖金额
    private int day;
    private String orderId;

    private Integer awardLimit;//奖品限制类型
    private Integer alipayType;//奖品子类型

    public static FilterParams adapter(ActivityOptionDto activityOptionDto, DoJoinActivityReq doJoinActivityReq, Integer amount,String orderId) {
        FilterParams filterParams = new FilterParams();
        filterParams.setSlotId(doJoinActivityReq.getSlotId());
        filterParams.setActivityId(activityOptionDto.getActivityId());
        filterParams.setActivityType(activityOptionDto.getActivityType());
        filterParams.setOptionId(activityOptionDto.getId());
        filterParams.setConsumerId(doJoinActivityReq.getConsumerId());
        filterParams.setAppId(doJoinActivityReq.getAppId());
        filterParams.setPrizeType(activityOptionDto.getPrizeType());
        filterParams.setDeviceId(doJoinActivityReq.getDeviceId());
        filterParams.setUserId(doJoinActivityReq.getUserId());
        filterParams.setIp(doJoinActivityReq.getIp());
        filterParams.setAmount(amount);
        filterParams.setOrderId(orderId);
        filterParams.setAwardLimit(activityOptionDto.getAwardLimit());
        filterParams.setAlipayType(activityOptionDto.getAlipayType());

        return filterParams;
    }

    public Long getSlotId() {
        return slotId;
    }

    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    public Long getOptionId() {
        return optionId;
    }

    public void setOptionId(Long optionId) {
        this.optionId = optionId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public Integer getActivityType() {
        return activityType;
    }

    public void setActivityType(Integer activityType) {
        this.activityType = activityType;
    }

    public String getPrizeType() {
        return prizeType;
    }

    public void setPrizeType(String prizeType) {
        this.prizeType = prizeType;
    }

    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public Integer getAmount() {
        return amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public int getDay() {
        return day;
    }

    public void setDay(int day) {
        this.day = day;
    }

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public Integer getAwardLimit() {
        return awardLimit;
    }

    public void setAwardLimit(Integer awardLimit) {
        this.awardLimit = awardLimit;
    }

    public Integer getAlipayType() {
        return alipayType;
    }

    public void setAlipayType(Integer alipayType) {
        this.alipayType = alipayType;
    }
}
