/**
* Project Name:access-activity-web
 * File Name:AccessActivityRuntimeException.java
 * Package Name:com.duiba.activity.accessweb.exception
 * Date:2016年11月16日下午4:37:44
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package com.duiba.tuia.youtui.web.exception;

import com.duiba.tuia.youtui.web.constant.ErrorCode;

/**
 * ClassName:AccessActivityRuntimeException <br/>
 * Date:     2016年11月16日 下午4:37:44 <br/>
 * @author   zp
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public class ActivityRuntimeException extends RuntimeException{
    
    private static final long serialVersionUID = 1L;

    private final String code;

    /**
     * 
     * Creates a new instance of AccessActivityRuntimeException.
     *
     */
    public ActivityRuntimeException() {
        //
        this.code = ErrorCode.E9999999.geteCode();
    }

    public ActivityRuntimeException(ErrorCode errorCode) {
        super(errorCode.geteDesc());
        this.code = errorCode.geteCode();
    }

    /**
     * Creates a new instance of AccessActivityRuntimeException.
     *
     * @param message
     */
    public ActivityRuntimeException(String message) {
        super(message);
        this.code = ErrorCode.E9999999.geteCode();
    }

    /**
     * Creates a new instance of AccessActivityRuntimeException.
     *
     * @param message
     * @param cause
     */
    public ActivityRuntimeException(String message, Throwable cause) {
        super(message, cause);
        this.code = ErrorCode.E9999999.geteCode();
    }

    /**
     * Creates a new instance of AccessActivityRuntimeException.
     *
     * @param cause
     */
    public ActivityRuntimeException(Throwable cause) {
        super(cause);
        this.code = ErrorCode.E9999999.geteCode();
    }

    public String getCode() {
        return code;
    }
}

