/**

 * Project Name:access-activity-web
 * File Name:AccessActivityException.java
 * Package Name:com.duiba.activity.accessweb.exception
 * Date:2016年11月16日下午4:29:34
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package com.duiba.tuia.youtui.web.exception;

import com.duiba.tuia.youtui.web.constant.ErrorCode;

/**
 * ClassName:AccessActivityException <br/>
 * Date:     2016年11月16日 下午4:29:34 <br/>
 * @author   zp
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public class ActivityException extends Exception{

    private static final long serialVersionUID = 1L;
    
    private final String code;
    private final String message;
    
    /**
     * 
     * Creates a new instance of AccessActivityException.
     *
     * @param code
     * @param message
     */
    public ActivityException(String code,String message){
        super(message);
        this.code = code;
        this.message = message;
    }
    
    /**
     * The Constructor.
     *
     * @param errorCode the error code
     */
    public ActivityException(ErrorCode errorCode){
        super(errorCode.geteDesc());
        this.code = errorCode.geteCode();
        this.message = errorCode.geteDesc();
    }

    /**
     * 
     * Creates a new instance of AccessActivityException.
     *
     */
    public ActivityException(){
        super();
        this.code = null;
        this.message = null;
    }
    
    /**
     * 
     * Creates a new instance of AccessActivityException.
     *
     * @param cause
     */
    public ActivityException(Throwable cause) {
        super(cause);
        this.code = null;
        this.message = null;
    }

    
    public String getCode() {
        return code;
    }

    @Override
    public String getMessage() {
        return message;
    }
    
}

