package com.duiba.tuia.youtui.web.embed;

import com.alibaba.fastjson.JSONObject;

public class GameEmbed extends Embed {

    private Long directpage;

    public GameEmbed(String dcm, String dsm, String dpm, Long consumerId, Long appId, String host,Long directpage) {
        super(dcm, dsm, dpm, consumerId, appId, host);
        this.directpage = directpage;
    }

    public void buildClose(JSONObject stInfo){
        stInfo.put("st_info_click_close", buildClick("st_info_click_close"));//排行榜关闭
        stInfo.put("st_info_exposure_close", buildExposure("st_info_exposure_close"));
    }

    public void buildAdvert(JSONObject stInfo){
        stInfo.put("st_info_click_advert", buildClick("st_info_click_advert"));//券曝光
        stInfo.put("st_info_exposure_advert", buildExposure("st_info_exposure_advert"));
    }

    public void buildAdvertButton(JSONObject stInfo){
        stInfo.put("st_info_click_advert_button", buildClick("st_info_click_advert_button"));//券按钮曝光
        stInfo.put("st_info_exposure_advert_button", buildExposure("st_info_exposure_advert_button"));
    }

    public void buildNoAdvertButton(JSONObject stInfo){
        stInfo.put("st_info_click_know_button", buildClick("st_info_click_know_button"));//无券时知道了按钮
        stInfo.put("st_info_exposure_know_button", buildExposure("st_info_exposure_know_button"));
    }

    public void buildRefreshGameButton(JSONObject stInfo){
        stInfo.put("st_info_click_refresh_button", buildClick("st_info_click_refresh_button"));//刷新游戏按钮曝光
        stInfo.put("st_info_exposure_refresh_button", buildExposure("st_info_exposure_refresh_button"));
    }

    public void buildRace(JSONObject stInfo){
        stInfo.put("st_info_click_race", buildClick("st_info_click_race"));//竞速模式
        stInfo.put("st_info_exposure_race", buildExposure("st_info_exposure_race"));
    }

    public void buildEndless(JSONObject stInfo){
        stInfo.put("st_info_click_endless", buildClick("st_info_click_endless"));//无尽模式
        stInfo.put("st_info_exposure_endless", buildExposure("st_info_exposure_endless"));
    }

    public void buildIntroduce(JSONObject stInfo){
        stInfo.put("st_info_click_introduce", buildClick("st_info_click_introduce"));//游戏介绍按钮
        stInfo.put("st_info_exposure_introduce", buildExposure("st_info_exposure_introduce"));
    }

    public void buildGet(JSONObject stInfo){
        stInfo.put("st_info_click_get", buildClick("st_info_click_get"));//获得金币按钮
        stInfo.put("st_info_exposure_get", buildExposure("st_info_exposure_get"));
    }

    public void buildRuleClose(JSONObject stInfo){
        stInfo.put("st_info_click_rule_close", buildClick("st_info_click_rule_close"));//规则页面关闭按钮
        stInfo.put("st_info_exposure_rule_close", buildExposure("st_info_exposure_rule_close"));
    }

    public void buildAmountClose(JSONObject stInfo){
        stInfo.put("st_info_click_amount_close", buildClick("st_info_click_amount_close"));//金币不足弹窗关闭按钮
        stInfo.put("st_info_exposure_amount_close", buildExposure("st_info_exposure_amount_close"));
    }

    public void buildGetAmount(JSONObject stInfo) {
        stInfo.put("st_info_click_get_amount", buildClick("st_info_click_get_amount"));//金币不足获取金币按钮
        stInfo.put("st_info_exposure_get_amount", buildExposure("st_info_exposure_get_amount"));
    }


    //押注游戏
    public void buildBetA(JSONObject stInfo){
        stInfo.put("st_info_click_bet_a", buildClick("st_info_click_bet_a"));//选项A点击
        stInfo.put("st_info_exposure_bet_a", buildExposure("st_info_exposure_bet_a"));
    }

    public void buildBetB(JSONObject stInfo){
        stInfo.put("st_info_click_bet_b", buildClick("st_info_click_bet_b"));//选项B点击
        stInfo.put("st_info_exposure_bet_b", buildExposure("st_info_exposure_bet_b"));
    }

    public void buildBetC(JSONObject stInfo){
        stInfo.put("st_info_click_bet_c", buildClick("st_info_click_bet_c"));//选项C点击
        stInfo.put("st_info_exposure_bet_c", buildExposure("st_info_exposure_bet_c"));
    }

    public void buildBetD(JSONObject stInfo){
        stInfo.put("st_info_click_bet_d", buildClick("st_info_click_bet_d"));//选项D点击
        stInfo.put("st_info_exposure_bet_d", buildExposure("st_info_exposure_bet_d"));
    }

    public void buildBetGameRule(JSONObject stInfo){
        stInfo.put("st_info_click_bet_game_rule", buildClick("st_info_click_bet_game_rule"));//游戏规则点击
        stInfo.put("st_info_exposure_bet_game_rule", buildExposure("st_info_exposure_bet_game_rule"));
    }

    public void buildBetModeChange(JSONObject stInfo){
        stInfo.put("st_info_click_bet_mode_change", buildClick("st_info_click_bet_mode_change"));//游戏押注切换
        stInfo.put("st_info_exposure_bet_mode_change", buildExposure("st_info_exposure_bet_mode_change"));
    }

    public void buildBetObtainAmount(JSONObject stInfo){
        stInfo.put("st_info_click_bet_obtain_amount", buildClick("st_info_click_bet_obtain_amount"));//游戏获取金币
        stInfo.put("st_info_exposure_bet_obtain_amount", buildExposure("st_info_exposure_bet_obtain_amount"));
    }

    public void buildBetGameOver(JSONObject stInfo){
        stInfo.put("st_info_click_bet_game_over", buildClick("st_info_click_bet_game_over"));//押注结束
        stInfo.put("st_info_exposure_bet_game_over", buildExposure("st_info_exposure_bet_game_over"));
    }

    public void buildBetGameRuleClose(JSONObject stInfo){
        stInfo.put("st_info_click_bet_game_rule_close", buildClick("st_info_click_bet_game_rule_close"));//规则关闭按钮
        stInfo.put("st_info_exposure_bet_game_rule_close", buildExposure("st_info_exposure_bet_game_rule_close"));
    }

    public Long getDirectpage() {
        return directpage;
    }

    public void setDirectpage(Long directpage) {
        this.directpage = directpage;
    }
}
