package com.duiba.tuia.youtui.web.embed;

import com.alibaba.fastjson.JSONObject;
import com.duiba.tuia.youtui.web.constant.Constants;
import com.duiba.tuia.youtui.web.tool.DomainConstantUtil;
import com.duiba.tuia.youtui.web.tool.RequestLocal;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * 尝试让埋点更简洁,让生活更美好 Created by wubo on 2017/9/1.
 */
public abstract class Embed implements Serializable {

    public static final String ST_INFO_DPM_CLICK = "st_info_dpm_click";
    public static final String ST_INFO_DPM_EXPOSURE ="st_info_dpm_exposure";
    public static final String ST_INFO_DPM_ADVERT_EXPOSURE ="st_info_dpm_advert_exposure";
    public static final String ST_INFO_DPM_CLOSE = "st_info_dpm_close";
    public static final String ST_INFO_DPM_BTN_CLOSE = "st_info_dpm_btn_close";
    public static final String ST_INFO_DPM_BTN_GET = "st_info_dpm_btn_get";

    private String dcm;
    private String dsm;
    private String dpm;
    private Long consumerId;
    private Long appId;
    private transient String host;
    private transient Map<String, String> embed = new HashMap<>();


    private Embed() {
    }

    public Embed(String dcm, String dsm, String dpm, Long consumerId, Long appId, String host) {
        this.dcm = dcm;
        this.dsm = dsm;
        this.dpm = dpm;
        this.consumerId = consumerId;
        this.appId = appId;
        this.host = host;
    }

    public String toJSONString() {
        return JSONObject.toJSONString(this);
    }

    /**
     * 子类方法调用时,该方法可以将子类的属性put到json中
     * @param jsonObject
     * @return
     */
    public String toJSONString(JSONObject jsonObject) {
        jsonObject.putAll((JSONObject) JSONObject.toJSON(this));
        return jsonObject.toJSONString();
    }

    /**
     * 构建点击埋点
     * /statistics/click
     */
    public String buildClickEmbed() {
        return buildClick(ST_INFO_DPM_CLICK);
    }

    /**
     * 构建通用点击埋点
     * /statistics/click
     * clickKey -- 暴露给前端的点击字段名
     */
    public String buildClick(String clickKey) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("domain4Web", "//" + host);
        jsonObject.put("url", Constants.PATH.STATISTICS + Constants.PATH.CLICK);
        String click = toJSONString(jsonObject);
        embed.put(clickKey, click);
        return click;
    }

    /**
     * 构建通用曝光埋点
     * 埋点服务器
     * exposureKey-- 暴露给前端的曝光字段名
     */
    public String buildExposure(String exposureKey) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("domain", DomainConstantUtil.getAppEmbedClickUrl());//埋点服务器Domain
        jsonObject.put("consumer_id", RequestLocal.get().getCid());
        String exposure = toJSONString(jsonObject);
        embed.put(exposureKey, exposure);
        return exposure;
    }




    /**
     * 构建广告点击埋点
     * 埋点服务器
     */
    public String buildAdvertEmbed4Web() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("domain4Web", "//" + host);
        jsonObject.put("domain", DomainConstantUtil.getAppEmbedClickUrl());//埋点服务器Domain
        jsonObject.put("url", Constants.PATH.ACTIVITY + Constants.PATH.SHOWLOG);
        String showLog = toJSONString(jsonObject);
        embed.put(ST_INFO_DPM_ADVERT_EXPOSURE, showLog);
        return showLog;
    }

    /**
     * 构建曝光埋点
     * 埋点服务器
     */
    public String buildExposureEmbed() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("domain", DomainConstantUtil.getAppEmbedClickUrl());//埋点服务器Domain
        String exposure = toJSONString(jsonObject);
        embed.put(ST_INFO_DPM_EXPOSURE, exposure);
        return exposure;
    }

    public String getDcm() {
        return dcm;
    }

    public Embed setDcm(String dcm) {
        this.dcm = dcm;
        return this;
    }

    public String getDsm() {
        return dsm;
    }

    public Embed setDsm(String dsm) {
        this.dsm = dsm;
        return this;
    }

    public String getDpm() {
        return dpm;
    }

    public Embed setDpm(String dpm) {
        this.dpm = dpm;
        return this;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public Embed setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
        return this;
    }

    public Long getAppId() {
        return appId;
    }

    public Embed setAppId(Long appId) {
        this.appId = appId;
        return this;
    }

    public String getHost() {
        return host;
    }

    public Embed setHost(String host) {
        this.host = host;
        return this;
    }

    /**
     * 禁止命名为getEmbed,
     * 否则后果自负
     * @return
     */
    public Map<String, String> embed() {
        return embed;
    }

    public void configEmbed(Map<String, String> embed) {
        this.embed = embed;
    }
}
