package com.duiba.tuia.youtui.web.embed;

import static com.duiba.tuia.youtui.web.constant.Constants.DSM.*;

import cn.com.duiba.tuia.activity.center.api.constant.PageType;
import cn.com.duiba.wolf.utils.UrlUtils;
import com.duiba.tuia.youtui.web.constant.Constants;
import org.apache.commons.lang3.StringUtils;

import java.util.Map;

/**
 * Duiba Source Monitor兑吧来源监控
 * dsm埋点规范：http://cf.dui88.com/pages/viewpage.action?pageId=5531888
 * a:最近一级资源位类型
 * b:资源位id
 * c:最近一级页面类型
 * d:页面id
 * <p>
 * 干他姨的dsm
 * Created by wubo on 2017/9/1.
 */
public class DsmBuilder extends DuibaMonitor {

    /**
     * 直投页区块的dsm
     *
     * @param dsm    直投页dsm
     * @param pageId 直投页id
     * @return dsm
     */
    public static String directBlockBuild(String dsm, Long pageId) {
        return StringUtils.isBlank(dsm) ? DSM_UNKNOWN : build(getParam(dsm, 1), getParam(dsm, 2), DSM_C_3, pageId);
    }

    /**
     * 前页面是活动的dsm
     * @param dsm 传递的dsm
     * @param activityId 活动id
     * @return dsm
     */
    public static String activityBuild(String dsm, Long activityId) {
        return StringUtils.isBlank(dsm) ? DSM_UNKNOWN : build(getParam(dsm, 1), getParam(dsm, 2), DSM_C_1, activityId);
    }

    /**
     * 前面是奖品页的dsm
     * @param dsm dsm
     * @return dsm
     */
    public static String recordBuild(String dsm) {
        return StringUtils.isBlank(dsm) ? DSM_UNKNOWN : build(getParam(dsm, 1), getParam(dsm, 2), DSM_C_2, "0");
    }

    /**
     * 返回拦截到某页面dsm
     *
     * @param sourceId 来源id
     * @return dsm
     */
    public static String returnToActCenterBuild(Long sourceId, String referer) {
        if (StringUtils.isBlank(referer)) {
            return DSM_UNKNOWN;
        }
        Map<String, String> params = UrlUtils.uRLRequest(referer);
        String dsm = params.get("dsm");
        if (StringUtils.isBlank(dsm)) {
            return DSM_UNKNOWN;
        }
        return build(getParam(dsm, 1), getParam(dsm, 2), pageTypeToDSMc(getPageTypeFromReferer(referer)), sourceId);
    }

    /**
     * 页面类型转DSM c位
     *
     * @param pageType 页面类型
     * @return int dsm_c
     */
    public static int pageTypeToDSMc(PageType pageType) {
        if (pageType == null) {
            return DSM_DEFAULT1;
        }
        int c;
        switch (pageType) {
            case ACTIVITY:
                c = DSM_C_1;
                break;
            case DIRECT:
                c = DSM_C_3;
                break;
            case ACTCENTER:
                c = DSM_C_4;
                break;
            case MAINMEET:
                c = DSM_C_5;
                break;
            default:
                c = DSM_DEFAULT1;

        }
        return c;
    }

    /**
     * 从referer中的链接 判断当前页面的页面类型
     * @param referer request head
     * @return PageType
     */
    public static PageType getPageTypeFromReferer(String referer) {
        if (StringUtils.isNotBlank(referer)) {
            if (referer.contains(Constants.PATH.MAINMEET + "/")) {
                return PageType.MAINMEET;
            } else if (referer.contains(Constants.PATH.ACTCENTER + "/")) {
                return PageType.ACTCENTER;
            } else if (referer.contains(Constants.PATH.ACTIVITY + "/")) {
                return PageType.ACTIVITY;
            } else if (referer.contains(Constants.PATH.DIRECTPAGE + "/")) {
                return PageType.DIRECT;
            }
        }
        return null;
    }

    /**
     * 下拉推荐位dsm构建
     * @param activityId
     * @return
     */
    public static String pullDownBuild(Long activityId) {
        return build(DSM_A_6, DSM_B_0, DSM_C_1, activityId);
    }
}
