package com.duiba.tuia.youtui.web.embed;

import cn.com.duiba.tuia.activity.center.api.constant.ActivityOptionType;
import cn.com.duiba.tuia.activity.center.api.dto.ActivityOrderDto;
import com.duiba.tuia.youtui.web.constant.Constants;
import com.duiba.tuia.youtui.web.model.UserAccount;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by xuefeng on 2017/12/7.
 */
public class ActivityEmbed extends Embed {

    private Long directpage;

    public ActivityEmbed(String dcm, String dsm, String dpm, Long consumerId, Long appId, String host, Long directpage) {
        super(dcm, dsm, dpm, consumerId, appId, host);
        this.directpage = directpage;
    }

    public String clickInfo(){
        this.buildClickEmbed();
        return super.embed().get("st_info_dpm_click");
    }

    public  String exposureInfo(){
        this.buildExposureEmbed();
        return super.embed().get("st_info_dpm_exposure");
    }

    public Long getDirectpage() {
        return directpage;
    }

    public void setDirectpage(Long directpage) {
        this.directpage = directpage;
    }

    /**
     * 构建我的奖品页奖品的埋点数据
     *
     * @param consumer
     * @param order
     * @param place
     * @param host
     * @return
     */
    public static Map<String, String> buildMineReordEmbed(UserAccount consumer, ActivityOrderDto order, int place, String host, Long directpage) {
        Map<String, String> embed = new HashMap<>();
        //dpm
        String dpm = DuibaMonitor.build(consumer.getAppId(), Constants.DPM.DPM_B_58, Constants.DPM.DPM_C_2, place);
        //dcm
        String dcm = "";
        if(ActivityOptionType.TYPE_PHYSICAL.getCode().equals(order.getPrizeType())) {
            dcm = DuibaMonitor.build(Constants.DCM.DCM_A_106, order.getGid(), Constants.DCM.DCM_C_1, Constants.DCM.DCM_D_1);
        } else if(ActivityOptionType.TYPE_ALIPAY.getCode().equals(order.getPrizeType())) {
            dcm = DuibaMonitor.build(Constants.DCM.DCM_A_107, order.getGid(), Constants.DCM.DCM_C_1, Constants.DCM.DCM_D_1);
        } else if(ActivityOptionType.TYPE_VIRTUAL.getCode().equals(order.getPrizeType())) {
            dcm = DuibaMonitor.build(Constants.DCM.DCM_A_108, order.getGid(), Constants.DCM.DCM_C_1, Constants.DCM.DCM_D_1);
        } else if(ActivityOptionType.TYPE_QB.getCode().equals(order.getPrizeType())) {
            dcm = DuibaMonitor.build(Constants.DCM.DCM_A_109, order.getGid(), Constants.DCM.DCM_C_1, Constants.DCM.DCM_D_1);
        } else if (ActivityOptionType.TYPE_BILL.equalsCode(order.getPrizeType())) {
            dcm = DuibaMonitor.build(Constants.DCM.DCM_A_111, order.getGid(), Constants.DCM.DCM_C_1, Constants.DCM.DCM_D_1);
        } else {
            dcm = DuibaMonitor.build(Constants.DCM.DCM_A_104, order.getAdvertId(), Constants.DCM.DCM_C_4, Constants.DCM.DCM_D_1);
        }

        //埋点信息
        String stInfoClick = new ActivityEmbed(dcm, null, dpm, consumer.getUserId(), consumer.getAppId(), host, directpage).clickInfo();
        String stInfoExposure = new ActivityEmbed(dcm, null, dpm, consumer.getUserId(), consumer.getAppId(), host, directpage).exposureInfo();

        embed.put("st_info_click", stInfoClick);
        embed.put("st_info_exposure", stInfoExposure);
        return embed;

    }

    /**
     * 我的奖品页埋点
     *
     * @param consumer
     * @param host
     * @return
     */
    public static Map<String, String> buildMineRecordListEmbed(UserAccount consumer, String host,Long directpage) {
        Map<String, String> map = new HashMap<>();
        //客服icon
        String iconDpm = DuibaMonitor.build(consumer.getAppId(), Constants.DPM.DPM_B_58, Constants.DPM.DPM_C_3, Constants.DPM.DPM_D_1);
        String iconDcm = DuibaMonitor.build(Constants.DCM.DCM_A_1016, (long) Constants.DCM.DCM_B_0, Constants.DCM.DCM_C_2, (long) Constants.DCM.DCM_D_0);
        String stInfoIconClick = new ActivityEmbed(iconDcm, null, iconDpm, consumer.getUserId(), consumer.getAppId(), host, directpage).clickInfo();
        String stInfoIconExposure = new ActivityEmbed(iconDcm, null, iconDpm, consumer.getUserId(), consumer.getAppId(), host, directpage).exposureInfo();

        map.put("st_info_icon_click", stInfoIconClick);
        map.put("st_info_icon_exposure", stInfoIconExposure);
        return map;
    }

    /**
     * 奖品详情页埋点
     *
     * @param consumer
     * @param host
     * @param order
     * @return
     */
    public static Map<String, String> buildRecordEmbed(UserAccount consumer, String host, ActivityOrderDto order,Long directpage) {
        Map<String, String> map = new HashMap<>();
        //详情页曝光
        String optionExposureDpm = DuibaMonitor.build(consumer.getAppId(), Constants.DPM.DPM_B_59, Constants.DPM.DPM_C_1, Constants.DPM.DPM_D_0);
        String optionExposureDcm = "";
        //详情页点击
        String optionClickDpm = "";
        String optionClickDcm = "";
        if(ActivityOptionType.TYPE_PHYSICAL.getCode().equals(order.getPrizeType())) {
            optionExposureDcm = DuibaMonitor.build(Constants.DCM.DCM_A_106, order.getGid(), Constants.DCM.DCM_C_2, Constants.DCM.DCM_D_1);
        } else if(ActivityOptionType.TYPE_ALIPAY.getCode().equals(order.getPrizeType())) {
            optionExposureDcm = DuibaMonitor.build(Constants.DCM.DCM_A_107, order.getGid(), Constants.DCM.DCM_C_2, Constants.DCM.DCM_D_1);
        } else if(ActivityOptionType.TYPE_VIRTUAL.getCode().equals(order.getPrizeType())) {
            optionExposureDcm = DuibaMonitor.build(Constants.DCM.DCM_A_108, order.getGid(), Constants.DCM.DCM_C_2, Constants.DCM.DCM_D_1);
        } else if(ActivityOptionType.TYPE_QB.getCode().equals(order.getPrizeType())) {
            optionExposureDcm = DuibaMonitor.build(Constants.DCM.DCM_A_109, order.getGid(), Constants.DCM.DCM_C_2, Constants.DCM.DCM_D_1);
        }else {
            optionExposureDcm = DuibaMonitor.build(Constants.DCM.DCM_A_104, order.getAdvertId(), Constants.DCM.DCM_C_5, Constants.DCM.DCM_D_1);
            optionClickDpm = DuibaMonitor.build(consumer.getAppId(), Constants.DPM.DPM_B_59, Constants.DPM.DPM_C_1, Constants.DPM.DPM_D_1);
            optionClickDcm = DuibaMonitor.build(Constants.DCM.DCM_A_104, order.getAdvertId(), Constants.DCM.DCM_C_5, (long)Constants.DCM.DCM_D_1);
        }

        String stInfoOptionClick = new ActivityEmbed(optionClickDcm, null, optionClickDpm, consumer.getUserId(), consumer.getAppId(), host, directpage).clickInfo();
        String stInfoOptionExposure = new ActivityEmbed(optionExposureDcm, null, optionExposureDpm, consumer.getUserId(), consumer.getAppId(), host, directpage).exposureInfo();

        map.put("st_info_click", stInfoOptionClick);
        map.put("st_info_exposure", stInfoOptionExposure);
        return map;
    }

    /**
     * 中奖公示埋点
     *
     * @param consumer
     * @param host
     * @param activityId
     * @param publicNoticeId
     * @return
     */
    public static Map<String, String> buildPublicNoticeEmbed(UserAccount consumer, String host, Long activityId, Long publicNoticeId) {
        Map<String, String> map = new HashMap<>();
        String dcm = DcmBuilder.publicNoticeBuild(activityId, publicNoticeId);
        //中奖公示按钮dpm
        String dpmButton = DpmBuilder.publicNoticeButtonBuild(consumer.getAppId());
        //中奖公示列表dpm
        String dpmList = DpmBuilder.publicNoticeListBuild(consumer.getAppId());
        //中奖公示关闭dpm
        String dpmClose = DpmBuilder.publicNoticeCloseBuild(consumer.getAppId());

        String stInfoButtonExposure = new ActivityEmbed(dcm, null, dpmButton, consumer.getUserId(), consumer.getAppId(), host, null).exposureInfo();
        String stInfoButtonClick = new ActivityEmbed(dcm, null, dpmButton, consumer.getUserId(), consumer.getAppId(), host, null).clickInfo();
        String stInfoListExposure = new ActivityEmbed(dcm, null, dpmList, consumer.getUserId(), consumer.getAppId(), host, null).exposureInfo();
        String stInfoCloseButtonClick = new ActivityEmbed(dcm, null, dpmClose, consumer.getUserId(), consumer.getAppId(), host, null).clickInfo();

        map.put("st_info_button_exposure", stInfoButtonExposure);//按钮曝光
        map.put("st_info_button_click", stInfoButtonClick);//按钮点击
        map.put("st_info_list_exposure", stInfoListExposure);//列表曝光
        map.put("st_info_close_click", stInfoCloseButtonClick);//关闭点击
        return map;
    }

    /**
     *
     * @param appId
     * @param consumerId
     * @param host
     * @param activityId
     * @return
     */
    public static Map<String, String> buildPullDownEmbed(Long appId, Long consumerId, String host, Long activityId) {
        Map<String, String> map = new HashMap<>();
        String dcm = DcmBuilder.pullDownBuild(activityId);
        String dpm = DpmBuilder.pullDownClickBuild(appId);
        String stInfoClick = new ActivityEmbed(dcm, null, dpm, consumerId, appId, host, null).clickInfo();

        map.put("st_info_click", stInfoClick);//点击
        return map;
    }
}
