/**
 * Project Name:tuia-youtui-web
 * File Name:StatisticsCtrl.java
 * Package Name:com.duiba.tuia.youtui.web.controller
 * Date:2017年4月10日下午3:44:26
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package com.duiba.tuia.youtui.web.controller;

import cn.com.duibaboot.ext.autoconfigure.accesslog.AccessLogFilter;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;

/**
 * ClassName:StatisticsCtrl <br/>
 * Function:  仅用于前端统计加载时间，无任何业务逻辑. <br/>
 * Date:     2017年4月10日 下午3:44:26 <br/>
 * @author cmd
 * @version
 * @since JDK 1.8
 * @see
 */
@Controller
@RequestMapping("statistics")
public class StatisticsCtrl {

    @ResponseBody
    @RequestMapping(value = "activityPagePerf", method = {RequestMethod.GET, RequestMethod.POST})
    public void activityPagePerf() {
        return;
    }

    /**
     *  活动广告坛层点击区块统计
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/click", method = {RequestMethod.GET, RequestMethod.POST})
    public void click(HttpServletRequest request) {
        String consumerId = request.getParameter("consumerId");
        String appId = request.getParameter("appId");
        if (StringUtils.isNotBlank(consumerId)) {
            AccessLogFilter.ConsumerId.set(Long.parseLong(consumerId));
        }
        if (StringUtils.isNotBlank(appId)) {
            AccessLogFilter.AppId.set(Long.parseLong(appId));
        }
        return;
    }


    /**
     * 落地页停留时间统计
     */
    @ResponseBody
    @RequestMapping(value = "stopPageCount", method = {RequestMethod.GET, RequestMethod.POST})
    public void stadyPageCount() {
        return;
    }

    /**
     * 长按时间统计
     */
    @ResponseBody
    @RequestMapping(value = "/longClick", method = RequestMethod.GET)
    public void longClick(HttpServletRequest request) {
        return;
    }
}

