package com.duiba.tuia.youtui.web.controller;

import cn.com.duiba.tuia.activity.center.api.dto.ActivityWinOrderDto;
import com.duiba.tuia.youtui.web.model.Result;
import com.duiba.tuia.youtui.web.model.UserAccount;
import com.duiba.tuia.youtui.web.model.rsp.RedPacketInfoRsp;
import com.duiba.tuia.youtui.web.model.rsp.RedPacketsRsp;
import com.duiba.tuia.youtui.web.service.RedPacketService;
import com.duiba.tuia.youtui.web.tool.RequestLocal;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

/**
 * 处理瓜分红包的接口
 *
 * @author lichao 2018/3/13
 */
@RestController
@RequestMapping("/redPacket")
@Api("瓜分红包接口API")
public class RedPacketController extends BaseController {

    /** 瓜分红包业务实现 */
    @Autowired
    private RedPacketService redPacketService;

    /**
     * 获取红包
     *
     * @param pageId 直投页id
     * @return 红包基本信息，红包数量
     */
    @RequestMapping(value = "/get", method = {RequestMethod.GET})
    @ApiOperation(value = "get", httpMethod = "GET", notes = "获取红包")
    public Result<RedPacketInfoRsp> get(HttpServletRequest request, Long pageId,String dsm,Long activityId) {

        try {
            UserAccount consumer = RequestLocal.get().getUserAccount();
            String host = request.getHeader("host");
            RedPacketInfoRsp rsp = redPacketService.getPacket(consumer, pageId, host, dsm,activityId);
            return successResult(rsp);
        } catch (Exception e) {
            return failResult(e);
        }
    }


    /**
     * 获取我的红包接口
     *
     * @param pageId 直投页id
     * @return 我抢到的红包数据
     */
    @RequestMapping(value = "/list", method = {RequestMethod.GET})
    @ApiOperation(value = "list", httpMethod = "GET", notes = "获取我的红包列表")
    public Result<RedPacketsRsp> list(Long pageId) {
        try {
            UserAccount consumer = RequestLocal.get().getUserAccount();
            RedPacketsRsp rsp = redPacketService.getPacketList(consumer,pageId);
            return successResult(rsp);
        } catch (Exception e) {
            return failResult(e);
        }
    }


    /**
     * 获取我的红包接口
     *
     * @param pageId 直投页id
     * @return 我抢到的红包数据
     */
    @RequestMapping(value = "/getAmount", method = {RequestMethod.GET})
    @ApiOperation(value = "getAmount", httpMethod = "GET", notes = "获取红包余额")
    public Result<Long> getAmount(Long pageId) {
        try {
            UserAccount consumer = RequestLocal.get().getUserAccount();
            Long rsp = redPacketService.getAmount(consumer,pageId);
            return successResult(rsp);
        } catch (Exception e) {
            return failResult(e);
        }
    }


    /**
     * 瓜分红包提现接口
     *
     * @param alipayName    阿里用户名
     * @param alipayAccount 阿里账户
     * @param amount        提现金额
     * @param pageId        直投页id
     * @return 订单信息
     */
    @RequestMapping(value = "/cash/withdraw", method = {RequestMethod.POST})
    @ApiOperation(value = "/cash/withdraw", httpMethod = "POST", notes = "现金钱包提现")
    public Result<ActivityWinOrderDto> cashWithdraw(@RequestParam String alipayName,
                                                    @RequestParam String alipayAccount,
                                                    @RequestParam Long amount,
                                                    @RequestParam Long pageId) {
        try {
            UserAccount consumer = RequestLocal.get().getUserAccount();
            return redPacketService.cashWithdraw(consumer,alipayName, alipayAccount, amount, pageId);
        } catch (Exception e) {
            return failResult(e);
        }

    }

    /**
     * 获取插件上的直投页链接
     * @param activityId
     * @return
     */
    @RequestMapping(value = "/getPageUrl", method = {RequestMethod.GET})
    @ApiOperation(value = "/getPageUrl", httpMethod = "GET", notes = "获取红包的直投页链接")
    public Result<String> getPageUrl(Long activityId,String dsm,HttpServletRequest request){
        try {
            String url = this.redPacketService.getPageUrl(activityId,dsm,request);
            return successResult(url);
        } catch (Exception e) {
            return failResult(e);
        }
    }

}
