/**
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */
package com.duiba.tuia.youtui.web.controller;

import cn.com.duiba.tuia.activity.center.api.dto.ActivityOrderDto;
import cn.com.duibaboot.ext.autoconfigure.accesslog.AccessLogFilter;
import com.duiba.tuia.youtui.web.exception.ActivityException;
import com.duiba.tuia.youtui.web.service.ActivityOrderService;
import com.duiba.tuia.youtui.web.tool.JsonUtils;
import com.duiba.tuia.youtui.web.tool.RequestLocal;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.io.Serializable;

/**
 * 描述: 活动页热力图
 *
 * @version v1.0
 * @auther guopengfei@duiba.com.cn
 * @date 2017/12/29 17:13
 */
@Api("活动页面热力图")
@RestController
@RequestMapping("/page/heatMap")
public class PageHeatMapController extends BaseController {

    @Autowired
    private ActivityOrderService activityOrderService;

    /**
     * 文档：http://cf.dui88.com/pages/viewpage.action?pageId=6681646
     *
     * @param pageId
     * @param pageType 0,"活动";1,"主会场";2,"活动中心";3,直投页;4,落地页(pageId是订单OID 示例: TAW-10001);
     * @param slotId
     * @param data
     */
    @ApiOperation(value = "活动页面热力图日志打印", httpMethod = "POST", notes = "活动页面热力图日志打印")
    @RequestMapping(value = "/addLog", method = RequestMethod.POST)
    public void addLog(String pageId, @RequestParam Integer pageType,
                       Long slotId, @RequestParam String data,
                       String childPageId) throws ActivityException {
        //这个方法仅负责在access.log中打印日志，没有业务逻辑可处理，勿删
        //异常数据手动过滤掉，防止报错
        try {
            if (StringUtils.isEmpty(pageId)) {
                return;
            }
            if (pageType == 4) {
                //根据订单OID得到广告ID，存入数据库
                String[] oidArr = pageId.split("-");
                if (oidArr.length < 2) {
                    return;
                }
                ActivityOrderDto activityOrderDto = activityOrderService.selectByIdAndConsumerId(oidArr[1], 0l);
                if (activityOrderDto == null) {
                    return;
                }
                AccessLogFilter.putExPair("pageId", activityOrderDto.getAdvertId());
            } else {
                AccessLogFilter.putExPair("pageId", pageId);
            }
            AccessLogFilter.putExPair("pageType", pageType.toString());
            AccessLogFilter.putExPair("slotId", slotId == null ? "0" : slotId.toString());
            AccessLogFilter.putExPair("appId", RequestLocal.get().getAppId() == null ? "0" : RequestLocal.get().getAppId().toString());
            AccessLogFilter.putExPair("childPageId", StringUtils.isEmpty(childPageId) ? "0" : childPageId);

            AccessLogFilter.putExPair("axisList", JsonUtils.jsonToList(data.replace("&quot;", "\""), Axis.class));
        } catch (Exception e) {
            logger.info("热力图打印参数日志格式有误, pageId={}, pageType={}, slotId={}, childPageId={}",
                    pageId, pageType, slotId, childPageId);
        }
    }

    private static class Axis implements Serializable {
        private static final long serialVersionUID = 7392918917775168915L;

        private String x;
        private String y;

        public String getX() {
            return x;
        }

        public void setX(String x) {
            this.x = x;
        }

        public String getY() {
            return y;
        }

        public void setY(String y) {
            this.y = y;
        }
    }

}
