
/**
 * Project Name:tuia-youtui-web<br>
 * File Name:GuidePageController.java<br>
 * Package Name:com.duiba.tuia.youtui.web.controller<br>
 * Date:2017年3月2日下午5:32:21<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 *
 */

package com.duiba.tuia.youtui.web.controller;

import cn.com.duibaboot.ext.autoconfigure.accesslog.AccessLogFilter;
import com.dianping.cat.Cat;
import com.duiba.tuia.youtui.web.bo.MainMeetBO;
import com.duiba.tuia.youtui.web.constant.Constants;
import com.duiba.tuia.youtui.web.exception.ActivityException;
import com.duiba.tuia.youtui.web.model.UserAccount;
import com.duiba.tuia.youtui.web.model.req.IndexReq;
import com.duiba.tuia.youtui.web.tool.RequestLocal;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;


/**
 * ClassName: GuidePageController <br/>
 * 主会场controller
 * date: 2017年3月2日 下午5:32:21 <br/>
 *
 * @author youhaijun
 * @version 
 * @since JDK 1.6
 */
@Controller
@RequestMapping("/mainMeet")
@Api("主会场API")
public class MainMeetController extends BaseController{
    
    @Autowired
    private MainMeetBO mainMeetBO;

    @RequestMapping(value = "/index", method = RequestMethod.GET)
    ModelAndView index(@ModelAttribute IndexReq req, HttpServletRequest request) throws ActivityException {
        // 1.获取用户信息
        UserAccount consumer = RequestLocal.get().getUserAccount();
        if (null == consumer || null == req.getId()) {
            return new ModelAndView(Constants.MODEL_ERROR);
        }
        try {
            Cat.logMetricForCount("活动中心-主会场访问");
        } catch (Exception e) {
            logger.error(Constants.CAT_ERROR, e);
        }
        try {
            req.setHost(request.getHeader("host"));
            AccessLogFilter.putExPair("use_host",request.getHeader("host"));
            AccessLogFilter.putExPair("agreement",request.getHeader("X-Forwarded-Proto")==null?"http":request.getHeader("X-Forwarded-Proto"));
            return mainMeetBO.index(request, req, consumer);
        } catch (Exception e) {
            logger.warn("初始化主会场失败，请检查主会场ID :" + req.getId(), e);
            return new ModelAndView(Constants.MODEL_ERROR);
        }
    }
}

