/**
 * Project Name:tuia-youtui-web
 * File Name:EngineLogController.java
 * Package Name:com.duiba.tuia.youtui.web.controller
 * Date:2017年2月27日下午3:17:26
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package com.duiba.tuia.youtui.web.controller;

import java.util.Enumeration;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.converter.json.MappingJacksonValue;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.tuia.advert.model.SpmlogReq;

import com.duiba.tuia.youtui.web.bo.ActivityBO;
import com.duiba.tuia.youtui.web.model.req.WebShowClickLogReq;
import com.google.common.collect.Maps;

/**
 * ClassName:EngineLogController <br/>
 * Date:     2017年2月27日 下午3:17:26 <br/>
 * @author   zp
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Controller
@RequestMapping("/engine")
public class EngineLogController extends BaseController{

    @Autowired
    private ActivityBO     activityBO;
    
    /**
     * 曝光日志.
     *
     * @param req the req
     * @param callback the callback
     * @param request the request
     * @param response the response
     * @return the model and view
     */
    @RequestMapping(value = "/spmshow", method = RequestMethod.GET)
    @ResponseBody
    public Object spmShow(@ModelAttribute WebShowClickLogReq req,String callback, HttpServletRequest request, HttpServletResponse response) {
        try {
            SpmlogReq log = BeanUtils.copy(req, SpmlogReq.class);
            Enumeration<String> enums = request.getParameterNames();
            Map<String,String> maps = Maps.newHashMap();
            while(enums.hasMoreElements()){
                String next = enums.nextElement();
                if(next.startsWith("_coll")){
                    maps.put(next, request.getParameter(next));
                }
            }
            log.setLogExtMap(maps);
            //打曝光日志
            activityBO.showLog(log);
            
            // 3 跨域json接口 返回
            MappingJacksonValue jacksonValue = new MappingJacksonValue(successResult());
            jacksonValue.setJsonpFunction(callback);
            return jacksonValue;
        } catch (Exception e) {
            logger.warn("曝光失败，请检查参数 :" + req, e);
            return failResult(e);
        }

    }
}

