package com.duiba.tuia.youtui.web.controller;

import com.duiba.tuia.youtui.web.model.Result;
import com.duiba.tuia.youtui.web.model.UserAccount;
import com.duiba.tuia.youtui.web.service.CustomizedEmbedService;
import com.duiba.tuia.youtui.web.tool.RequestLocal;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import java.util.Map;

/**
 * 为定制的需求增加埋点的的Controller
 *
 * @author lichao 2018/3/29
 */
@RestController
@RequestMapping("/embed")
@Api("定制需求的埋点信息")
public class EmbedController extends BaseController {

    /**
     * 处理定制需求埋点的service
     */
    @Autowired
    private CustomizedEmbedService customizedEmbedService;

    /**
     * 获取传奇抽时装定制埋点接口
     *
     * @param pageId  直投页id
     * @param dsm     直投页dsm
     * @param request request
     * @author lichao 2018/3/30
     */
    @RequestMapping(value = "/chuanqiEmbed", method = {RequestMethod.GET})
    @ApiOperation(value = "chuanqiEmbed", httpMethod = "GET", notes = "获取传奇抽时装定制埋点接口")
    public Result<Map<String, String>> getChuanqiEmbed(@Valid Long pageId, String dsm, HttpServletRequest request) {
        try {
            UserAccount consumer = RequestLocal.get().getUserAccount();
            String host = request.getHeader("host");
            return successResult(customizedEmbedService.buildChuanqiEmbed(pageId, dsm, consumer, host));
        } catch (Exception e) {
            return failResult(e);
        }
    }

    /**
     * 获取 找茬(直投页) 定制埋点接口
     *
     * @param pageId  页面ID
     * @param times   第几局
     * @param dsm     页面DSM
     * @param request
     * @return
     */
    @RequestMapping(value = "/findDiffEmbed", method = RequestMethod.GET)
    @ApiOperation(value = "findDiffEmbed", httpMethod = "GET", notes = "获取找茬(直投页)定制埋点接口")
    public Result<Map<String, String>> getFindDiffEmbed(Long pageId, Long times, String dsm, HttpServletRequest request) {
        try {
            UserAccount consumer = RequestLocal.get().getUserAccount();
            String host = request.getHeader("host");
            return successResult(customizedEmbedService.buildFindDiffEmbed(pageId, times, dsm, consumer, host));
        } catch (Exception e) {
            return failResult(e);
        }
    }

}
