package com.duiba.tuia.youtui.web.controller;

import cn.com.duibaboot.ext.autoconfigure.accesslog.AccessLogFilter;
import com.duiba.tuia.youtui.web.model.Result;
import com.duiba.tuia.youtui.web.model.rsp.BigAndSmallRsp;
import com.duiba.tuia.youtui.web.service.CustomizedService;
import io.swagger.annotations.Api;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;

/**
 * 某些定制需求的controller
 *
 * @author lichao 2018/3/28
 */
@Controller
@RequestMapping("/customized")
@Api("定制需求的API")
public class CustomizedController extends BaseController {

    /**
     * 定制的需求实现service
     */
    @Resource
    private CustomizedService customizedService;

    /**
     * 猜大小获取猜中的金钱
     */
    @ResponseBody
    @RequestMapping(value = "/bigSmall", method = {RequestMethod.GET})
    public Result<BigAndSmallRsp> bigSmallMoney(@Valid Long activityId) {

        try {
            return successResult(customizedService.bigSmallMoney(activityId));
        } catch (Exception e) {
            return failResult(e);
        }
    }

    /**
     * 定制需求，为唯品会切量的时候记录点击日志
     */
    @RequestMapping(value = "/wphRedirect", method = {RequestMethod.GET, RequestMethod.POST})
    public void wphRedirect(String url, HttpServletRequest request, HttpServletResponse response) {
        try {
            if(StringUtils.isBlank(url)){
                return;
            }
            AccessLogFilter.putExPair("use_host",request.getHeader("host"));
            AccessLogFilter.putExPair("agreement",request.getHeader("X-Forwarded-Proto")==null?"http":request.getHeader("X-Forwarded-Proto"));

            response.sendRedirect(StringEscapeUtils.unescapeHtml3(url));

        } catch (Exception e) {
            logger.error("wphRedirect跳转页面失败，请检查", e);
        }

    }

}
