package com.duiba.tuia.youtui.web.controller;

import cn.com.duiba.intersection.serivce.api.remoteservice.RemoteIpLibraryService;
import cn.com.duiba.intersection.serivce.api.remoteservice.dto.IpLibraryDto;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.perf.timeprofile.RequestTool;
import com.duiba.tuia.youtui.web.constant.Constants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;

/**
 * Created by wubo on 2017/4/25.
 * 通用接口
 * 一些通用的接口，跟业务关系不大的可以放在这里
 */
@RestController
@RequestMapping("/common")
public class CommonController extends BaseController {

    @Autowired
    private RemoteIpLibraryService remoteIpLibraryService;

    /**
     * queryInfoFromIP:(查询客户端ip信息). <br/>
     * @param request
     * @return {"code":"0000000","desc":"成功","data":{"id":805093,"startIpNum":1944977408,"endIpNum":1945010175,"country":"中国","province":"浙江","city":"杭州","district":"","isp":"","code":330100},"success":true}
     */
    @RequestMapping("ip")
    public Object queryInfoFromIP(HttpServletRequest request) {

        DubboResult<IpLibraryDto> dr;
        try {
            dr = this.remoteIpLibraryService.findByIp(RequestTool.getIpAddr(request));
            return super.successResult(dr.getResult());
        } catch (Exception e) {
            return super.failResult(e);
        }
    }

    @RequestMapping("/error")
    public ModelAndView error(){
        return new ModelAndView(Constants.MODEL_ERROR);
    }
}
