package com.duiba.tuia.youtui.web.controller;

import com.alibaba.fastjson.JSONObject;
import com.duiba.tuia.youtui.web.model.UserAccount;
import com.duiba.tuia.youtui.web.model.rsp.BetGameResult;
import com.duiba.tuia.youtui.web.model.rsp.BetHistoryResult;
import com.duiba.tuia.youtui.web.service.BetGameService;
import com.duiba.tuia.youtui.web.tool.RequestLocal;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;


/**
 * @author liuqingsong
 * @version 1.0 新增押注游戏
 * @date 2018-02-06
 */
@Controller
@RequestMapping("/betGame")
@Api("押注游戏API")
public class BetGameController extends BaseController {

    @Autowired
    private BetGameService betGameService;

    /**
     * @return
     */
    @RequestMapping(value = "/getResult")
    @ResponseBody
    @ApiOperation(value = "获取游戏结果", httpMethod = "GET", notes = "获取游戏结果")
    public BetGameResult getResult(Long id) {
        UserAccount consumer = RequestLocal.get().getUserAccount();
        return betGameService.getResult(id, consumer.getUserId());
    }

    /**
     * @return
     */
    @RequestMapping(value = "/getHistoryResult")
    @ResponseBody
    @ApiOperation(value = "获取历史结果", httpMethod = "GET", notes = "获取历史结果")
    public BetHistoryResult getHistoryResult(Long id) {
        return betGameService.getHistoryResult(id);
    }

    @RequestMapping(value = "/getBetEmbed")
    @ResponseBody
    @ApiOperation(value = "押注游戏埋点", httpMethod = "GET", notes = "押注游戏埋点")
    public JSONObject getBetEmbed(Long id, Long directId, HttpServletRequest request) {
        Long userId = RequestLocal.get().getCid();
        String host = request.getHeader("host");
        Long appId = RequestLocal.get().getAppId();
        String slotId = RequestLocal.get().getSlotId();
        return betGameService.getBetEmbed(id, appId, userId, host, StringUtils.isNotBlank(slotId) ? slotId : "", directId == null ? -1 : directId);
    }

    @RequestMapping(value = "/getData")
    @ResponseBody
    @ApiOperation(value = "获取游戏大盘数据", httpMethod = "GET", notes = "获取游戏大盘数据")
    public String getData(Long id) {

        return betGameService.getData(id);
    }

}
