package com.duiba.tuia.youtui.web.controller;

import cn.com.duiba.credits.sdk.CreditConsumeResult;
import cn.com.duiba.tuia.activity.center.api.dto.ActivityWinOrderDto;
import com.alibaba.fastjson.JSONObject;
import com.duiba.tuia.youtui.web.bo.BalanceBO;
import com.duiba.tuia.youtui.web.model.Result;
import com.duiba.tuia.youtui.web.model.req.BalanceRecordQuery;
import com.duiba.tuia.youtui.web.model.rsp.PageBalanceRecord;
import com.duiba.tuia.youtui.web.service.BalanceRecordService;
import com.duiba.tuia.youtui.web.service.UserBalanceService;
import com.duiba.tuia.youtui.web.tool.JsonUtils;
import com.duiba.tuia.youtui.web.tool.RequestLocal;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.util.List;

/**
 * Created by Administrator on 2017/12/12.
 */
@RestController
@RequestMapping("/balance")
@Api("金币账户API")
public class BalanceController extends BaseController {

    @Autowired
    private BalanceBO balanceBO;

    @Resource
    private UserBalanceService userBalanceService;

    @Resource
    private BalanceRecordService balanceRecordService;

    @RequestMapping(value = "/getWin", method = { RequestMethod.GET })
    @ApiOperation(value = "getWin", httpMethod = "GET", notes = "中奖公示接口")
    public Result<List<String>> getWin(Long pageId, HttpServletRequest request, HttpServletResponse response) {
        try {
            return successResult(balanceBO.assemblyReward(request));
        } catch (Exception e) {
            return failResult(e);
        }
    }

    /**
     * 用户中奖逻辑
     *
     * @param pageId
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/getReward", method = {RequestMethod.POST})
    @ApiOperation(value = "getReward", httpMethod = "POST", notes = "获取零钱奖励接口")
    public Result<Long> getReward(@Valid Long pageId, HttpServletRequest request, HttpServletResponse response) {
        try {
            return successResult(balanceBO.getReward(pageId, request));
        } catch (Exception e) {
            return failResult(e);
        }
    }

    /**
     * 账户详情
     */
    @RequestMapping(value = "/getAmount", method = RequestMethod.GET)
    @ApiOperation(value = "getAmount", httpMethod = "POST", notes = "获取零钱变动接口")
    public Result<Object> getAmount(Integer balanceType,HttpServletRequest request, HttpServletResponse response) {
        try {
            Long userId = RequestLocal.get().getCid();
            return successResult(userBalanceService.getAmount(userId,balanceType));
        } catch (Exception e) {
            return failResult(e);
        }
    }

    @RequestMapping(value = "/getFirstLoginReward", method = RequestMethod.POST)
    @ApiOperation(value = "getFirstLoginReward", httpMethod = "POST", notes = "获取首次登陆奖励接口")
    public Result<Object> getFirstLoginReward(Integer balanceType,HttpServletRequest request, HttpServletResponse response) {
        try {
            Long userId = RequestLocal.get().getCid();
            return successResult(userBalanceService.getAmount(userId,balanceType));
        } catch (Exception e) {
            return failResult(e);
        }
    }

    @ResponseBody
    @RequestMapping(value = "/list", method = {RequestMethod.GET})
    @ApiOperation(value = "list", httpMethod = "GET", notes = "查看明细接口")
    public Result<PageBalanceRecord> detail(@ModelAttribute BalanceRecordQuery query,HttpServletRequest request, HttpServletResponse response){
        try {
            query.setUserId(RequestLocal.get().getCid());
            return successResult(balanceRecordService.pageQuery(query, request));
        } catch (Exception e) {
            return failResult(e);
        }
    }

    /**
     * 获取现金钱包提现配置
     *
     * @return
     */
    @RequestMapping(value = "/withdraw/config", method = {RequestMethod.GET})
    @ApiOperation(value = "/withdraw/config", httpMethod = "GET", notes = "获取现金钱包提现配置")
    public Result<Object> getWithdrawConfig() {
        try {
            return successResult(JsonUtils.jsonToList(userBalanceService.getWithdrawConfig(), Object.class));
        } catch (Exception e) {
            return failResult(e);
        }
    }

    /**
     * 获取现金钱包提现配置
     *
     * @return
     */
    @RequestMapping(value = "/cash/withdraw", method = {RequestMethod.POST})
    @ApiOperation(value = "/cash/withdraw", httpMethod = "POST", notes = "现金钱包提现")
    public Result<ActivityWinOrderDto> cashWithdraw(@RequestParam String alipayName,
                                                    @RequestParam String alipayAccount,
                                                    @RequestParam Long amount,
                                                    @RequestParam Long pageId) {
        try {
            return balanceBO.cashWithdraw(alipayName, alipayAccount, amount, pageId);
        } catch (Exception e) {
            return failResult(e);
        }
    }

    @RequestMapping(value = "/creditConsume", method = {RequestMethod.GET})
    @ApiOperation(value = "/creditConsume", httpMethod = "GET", notes = "兑吧积分商城积分消耗接口")
    public String creditConsume(HttpServletRequest request) {
        try {
            return balanceBO.creditConsume(request);
        } catch (Exception e) {
            return new CreditConsumeResult(false).toString();
        }
    }

    @RequestMapping(value = "/creditNotify", method = {RequestMethod.GET})
    @ApiOperation(value = "/creditNotify", httpMethod = "GET", notes = "兑吧积分商城兑换结果通知接口")
    public String creditNotify(HttpServletRequest request) {
        try {
            return balanceBO.creditNotify(request);
        } catch (Exception e) {
            return "通知失败";
        }
    }

}
