package com.duiba.tuia.youtui.web.constant.datas;

import cn.com.duiba.tuia.activity.center.api.constant.LayerSkinType;
import com.google.common.collect.Maps;

import java.util.Map;

/**
 * 行业广告弹层的广告id对应的弹层type
 *
 * @author lichao 2018/4/24
 */
public class AdvertLayerData {

    //key: advertId
    private static Map<Long, LayerSkinType> datas = Maps.newHashMap();


    static {
        // 教育行业弹层
        datas.put(25590L, LayerSkinType.COUPON_EDUCATION);
                datas.put(14705L, LayerSkinType.COUPON_EDUCATION);
                datas.put(24255L, LayerSkinType.COUPON_EDUCATION);
                datas.put(27882L, LayerSkinType.COUPON_EDUCATION);
                datas.put(23646L, LayerSkinType.COUPON_EDUCATION);


                //贷款行业弹层
                datas.put(27269L, LayerSkinType.COUPON_LOAN);
                datas.put(22906L, LayerSkinType.COUPON_LOAN);
                datas.put(27485L, LayerSkinType.COUPON_LOAN);
                datas.put(27813L, LayerSkinType.COUPON_LOAN);
                datas.put(27539L, LayerSkinType.COUPON_LOAN);

                //贷款行业弹层
                datas.put(23239L, LayerSkinType.COUPON_INSURANCE);
                datas.put(23453L, LayerSkinType.COUPON_INSURANCE);
                datas.put(23225L, LayerSkinType.COUPON_INSURANCE);
                datas.put(25073L, LayerSkinType.COUPON_INSURANCE);
                datas.put(20143L, LayerSkinType.COUPON_INSURANCE);


    }


    /**
     * 根据广告id查询定制的行业广告弹层
     * @param advertId 广告id
     */
    public static LayerSkinType getByAdvertId(Long advertId) {
        return datas.get(advertId);
    }
}
