package com.duiba.tuia.youtui.web.constant;

import org.apache.commons.lang3.StringUtils;
import java.util.HashMap;
import java.util.Map;

public class TaoBaoCode {

    private TaoBaoCode() {
    }

    private static Map<Long, String> code;
    private static final String DUIBA_CODE = "￥biH0057vztw￥";
    private static final String TUIA_CODE = "￥jYX0057Efx0￥";

    static {
        code = new HashMap<>();
        code.put(22762L, "￥Cvke057vrRE￥");//猎豹清理大师
        code.put(36007L, "￥nKIj057Fw29￥");//收钱吧
        code.put(26744L, "￥mbBT057vN46￥");//悦动圈
        code.put(23898L, "￥aL4t057v4k5￥");//爱奇艺
        code.put(21143L, TUIA_CODE);//该媒体可能用兑吧活动出券
        //兑吧媒体
    }

    public static String getCode(Long appId,String tuiaId) {
        String rs = code.get(appId);
        if (StringUtils.isNotBlank(rs)) {
            return rs;
        }
        if (StringUtils.isNotBlank(tuiaId)) {
            if (tuiaId.startsWith(Constants.THE_PREFIX_ORDERID) || tuiaId.startsWith(Constants.THE_PREFIX_DIRECT) || tuiaId.startsWith(Constants.THE_PREFIX_LINK)) {
                return TUIA_CODE;
            }
            return DUIBA_CODE;
        }

        return null;
    }

}
